/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business.impl;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.album.business.AlbumCreatedStreamHandler;
import de.justsoftware.onx.album.business.AlbumImageCreatedStreamHandler;
import de.justsoftware.onx.album.business.ImageCommentedStreamHandler;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.business.DriveDocumentCommentStreamHandler;
import de.justsoftware.onx.container.business.DriveDocumentNewVersionStreamHandler;
import de.justsoftware.onx.container.business.EntityCreatedStreamHandler;
import de.justsoftware.onx.container.business.EntityDescriptionUpdatedHandler;
import de.justsoftware.onx.container.business.EntityNewMembershipHandler;
import de.justsoftware.onx.container.business.EntityParentsChangedStreamHandler;
import de.justsoftware.onx.container.business.EntityVersionPublishedStreamHandler;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.survey.business.SurveyPublishedStreamHandler;
import de.justsoftware.onx.videolink.business.VideolinkCommentedStreamHandler;
import de.justsoftware.onx.videolink.business.VideolinkCreatedStreamHandler;
import de.justsoftware.onx.wikieditor.business.WikiNewVersionStreamHandler;
import de.justsoftware.onx.workstream.business.MicroblogPostingHandler;
import de.justsoftware.onx.workstream.business.WorkstreamHandlerForTypeService;
import de.justsoftware.onx.workstream.business.WorkstreamMessageHandler;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.model.messages.WorkstreamMessage;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="workstreamHandlerForTypeService")
public class WorkstreamHandlerForTypeServiceImpl
implements WorkstreamHandlerForTypeService {
    private static final WorkstreamMessageHandler<WorkstreamMessage> UNSUPPORTED_TYPE_HANDLER = new WorkstreamMessageHandler<WorkstreamMessage>(){

        @Override
        public ImmutableSetMultimap<String, String> attributesToDelete(Set<? extends ItemId> itemIds) {
            return ImmutableSetMultimap.of();
        }

        @Override
        public boolean keepMessageWithNoAttachments() {
            return true;
        }

        @Override
        public ImmutableMap<WorkstreamMessageId, WorkstreamMessage> convert(Iterable<DBWorkstreamMessage> messages, Map<PersonId, PersonTeaserModel> personTeasers, ImmutableSetMultimap<Optional<WorkstreamMessageId>, Action> workstreamPermissions, AuthorizationCheckContextWithLocale authorizationContext) {
            return ImmutableMap.of();
        }
    };
    @Autowired
    private AlbumCreatedStreamHandler _albumCreatedStreamHandler;
    @Autowired
    private AlbumImageCreatedStreamHandler _albumImageCreatedStreamHandler;
    @Autowired
    private EntityCreatedStreamHandler _entityCreatedStreamHandler;
    @Autowired
    private EntityNewMembershipHandler _entityNewMembershipHandler;
    @Autowired
    private ImageCommentedStreamHandler _imageCommentedStreamHandler;
    @Autowired
    private MicroblogPostingHandler _microblogPostingHandler;
    @Autowired
    private VideolinkCommentedStreamHandler _videolinkCommentedStreamHandler;
    @Autowired
    private VideolinkCreatedStreamHandler _videolinkCreatedStreamHandler;
    @Autowired
    private WikiNewVersionStreamHandler _wikiNewVersionStreamHandler;
    @Autowired
    private EntityDescriptionUpdatedHandler _entityDescriptionUpadtedHandler;
    @Autowired
    private EntityVersionPublishedStreamHandler _entityVersionPublishedHandler;
    @Autowired
    private EntityParentsChangedStreamHandler _entityParentsChangedHandler;
    @Autowired
    private SurveyPublishedStreamHandler _surveyPublishedStreamHandler;
    @Autowired
    private DriveDocumentNewVersionStreamHandler _driveDocumentNewVersionStreamHandler;
    @Autowired
    private DriveDocumentCommentStreamHandler _driveDocumentCommentStreamHandler;

    @Override
    public WorkstreamMessageHandler<?> getHandler(WorkstreamMessageType type) {
        return (WorkstreamMessageHandler)type.accept(this);
    }

    @Override
    public AlbumCreatedStreamHandler visitAlbumCreated() {
        return this._albumCreatedStreamHandler;
    }

    @Override
    public ImageCommentedStreamHandler visitAlbumImageCommented() {
        return this._imageCommentedStreamHandler;
    }

    @Override
    public AlbumImageCreatedStreamHandler visitAlbumImageCreated() {
        return this._albumImageCreatedStreamHandler;
    }

    @Override
    public DriveDocumentNewVersionStreamHandler visitDriveDocumentNewVersion() {
        return this._driveDocumentNewVersionStreamHandler;
    }

    @Override
    public WorkstreamMessageHandler<?> visitDriveDocumentComment() {
        return this._driveDocumentCommentStreamHandler;
    }

    @Override
    public EntityCreatedStreamHandler visitEntityCreated() {
        return this._entityCreatedStreamHandler;
    }

    @Override
    public EntityNewMembershipHandler visitEntityNewMembership() {
        return this._entityNewMembershipHandler;
    }

    @Override
    public MicroblogPostingHandler visitMicroblogPosting() {
        return this._microblogPostingHandler;
    }

    @Override
    public VideolinkCommentedStreamHandler visitVideolinkCommented() {
        return this._videolinkCommentedStreamHandler;
    }

    @Override
    public VideolinkCreatedStreamHandler visitVideolinkCreated() {
        return this._videolinkCreatedStreamHandler;
    }

    @Override
    public WikiNewVersionStreamHandler visitWikiVersionCreated() {
        return this._wikiNewVersionStreamHandler;
    }

    @Override
    public EntityDescriptionUpdatedHandler visitEntityDescriptionUpdated() {
        return this._entityDescriptionUpadtedHandler;
    }

    @Override
    public EntityVersionPublishedStreamHandler visitEntityVersionPublished() {
        return this._entityVersionPublishedHandler;
    }

    @Override
    public EntityParentsChangedStreamHandler visitEntityParentsChanged() {
        return this._entityParentsChangedHandler;
    }

    @Override
    public WorkstreamMessageHandler<?> visitSurveyPublished() {
        return this._surveyPublishedStreamHandler;
    }

    @Override
    public WorkstreamMessageHandler<?> visitUnsupportedType() {
        return UNSUPPORTED_TYPE_HANDLER;
    }
}

