/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business.impl;

import com.freiheit.superoperty.event.SuperopertyChangeEvent;
import com.freiheit.superoperty.event.SuperopertyChangeListener;
import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.cache.AbstractMapLoadingCacheAccessor;
import de.justsoftware.onx.common.cache.AbstractSingleLoadingCacheAccessor;
import de.justsoftware.onx.common.deletion.DeleteTransactionCallback;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.visibility.integration.persistence.EntityParentsDAO;
import de.justsoftware.onx.workstream.business.WorkstreamDataService;
import de.justsoftware.onx.workstream.business.WorkstreamReadMonitor;
import de.justsoftware.onx.workstream.business.WorkstreamTypeAttributeValue;
import de.justsoftware.onx.workstream.business.model.WorkstreamMessagePublishedStateFilter;
import de.justsoftware.onx.workstream.integration.persistence.WorkstreamDAO;
import de.justsoftware.onx.workstream.integration.persistence.model.DBWorkstreamMessageAttachment;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterModel;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.model.attachments.Attachment;
import de.justsoftware.onx.workstream.shared.model.attachments.AttachmentType;
import de.justsoftware.onx.workstream.shared.model.attachments.DriveDocumentAttachment;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

@Service
public class WorkstreamDataServiceImpl
implements WorkstreamDataService {
    private final WorkstreamDAO _workstreamDAO;
    private final NewestWorkstreamDateDirectCacheAccessor _newestWorkstreamDateDirectCacheAccessor;
    private final NewestWorkstreamDateIndirectCacheAccessor _newestWorkstreamDateIndirectCacheAccessor;
    private final PinnedHideDateCacheAccessor _pinnedHideDateCacheAccessor;
    private final EntityParentsDAO _entityParentsDAO;
    private final WorkstreamReadMonitor _workstreamReadMonitor;
    private final Settings _settings;
    private final TransactionHelper _transactionHelper;

    @ParametersAreNonnullByDefault
    @Autowired
    public WorkstreamDataServiceImpl(EhcacheClient cache, WorkstreamDAO workstreamDAO, EntityParentsDAO entityParentsDAO, WorkstreamReadMonitor workstreamReadMonitor, Settings settings, TransactionHelper transactionHelper) {
        this._workstreamDAO = workstreamDAO;
        this._entityParentsDAO = entityParentsDAO;
        this._workstreamReadMonitor = workstreamReadMonitor;
        this._settings = settings;
        this._newestWorkstreamDateDirectCacheAccessor = new NewestWorkstreamDateDirectCacheAccessor(cache, workstreamDAO, workstreamReadMonitor);
        this._newestWorkstreamDateIndirectCacheAccessor = new NewestWorkstreamDateIndirectCacheAccessor(cache, workstreamDAO, workstreamReadMonitor);
        this._pinnedHideDateCacheAccessor = new PinnedHideDateCacheAccessor(cache, workstreamDAO);
        this._settings.getWorkstreamReadConfigProperty().addSuperopertyChangeListener(new SuperopertyChangeListener(){

            public void superopertyChange(SuperopertyChangeEvent arg0) {
                WorkstreamDataServiceImpl.this._newestWorkstreamDateDirectCacheAccessor.invalidateAll();
                WorkstreamDataServiceImpl.this._newestWorkstreamDateIndirectCacheAccessor.invalidateAll();
            }
        });
        this._transactionHelper = transactionHelper;
    }

    @Override
    public WorkstreamMessageId saveEntry(final DBWorkstreamMessage entry, final ImmutableList<? extends Attachment> attachments, final ItemId coverPictureId, final WorkstreamDataService.AttachmentProcessor attachmentProcessor) {
        DeleteTransactionCallback callback = this._settings.getWorkstreamReadConfig().isPollingEnabled() ? new InvalidateNewestMessagesCallback((Iterable<DBWorkstreamMessage>)ImmutableList.of((Object)entry)) : DeleteTransactionCallback.DO_NOTHING_CALLBACK;
        WorkstreamMessageId resultId = this._transactionHelper.doInTransaction(new TransactionCallback<WorkstreamMessageId>(){

            public WorkstreamMessageId doInTransaction(TransactionStatus status) {
                WorkstreamMessageId messageId = WorkstreamDataServiceImpl.this._workstreamDAO.saveEntry(entry);
                ImmutableList<? extends Attachment> processedAttachments = attachmentProcessor == null ? attachments : attachmentProcessor.processWithWorkstreamMessageId((ImmutableList<? extends Attachment>)attachments, messageId);
                ImmutableSet.Builder attachmentsBuilder = ImmutableSet.builder();
                Optional<DriveDocumentId> coverDocumentId = WorkstreamDataServiceImpl.this.getPersistedCoverImageId(processedAttachments, coverPictureId);
                coverDocumentId.ifPresent(arg_0 -> ((ImmutableSet.Builder)attachmentsBuilder).add(arg_0));
                processedAttachments.stream().map(Attachment::getId).filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableSet.Builder)attachmentsBuilder).add(arg_0));
                WorkstreamDataServiceImpl.this._workstreamDAO.saveAttachments(messageId, (Set<ItemId>)attachmentsBuilder.build());
                return messageId;
            }
        });
        callback.afterCommit();
        return resultId;
    }

    @Override
    public void publish(Set<WorkstreamMessageId> messageIds, Date publishDate) {
        this._workstreamDAO.publish(messageIds, publishDate);
    }

    @Override
    public List<DBWorkstreamMessage> getWorkstream(ItemId itemId, WorkstreamMessagePublishedStateFilter publishedStateFilter, Boolean pinned, Date offset, Date maxAge, Integer max, WorkstreamFilterModel filter, PersonId personId, Set<String> roles, ImmutableSet<ItemId> originIds) {
        return this._workstreamDAO.getWorkstream(itemId, publishedStateFilter, pinned, offset, maxAge, max, filter, personId, roles, originIds);
    }

    @Override
    public ImmutableSet<WorkstreamMessageId> getMessagesByAttributes(Set<WorkstreamTypeAttributeValue> typeAndAttributes) {
        return this._workstreamDAO.getMessagesByAttributes(typeAndAttributes);
    }

    @Override
    public DeleteTransactionCallback deleteEntriesByIds(Set<WorkstreamMessageId> ids) {
        if (ids.isEmpty()) {
            return DeleteTransactionCallback.DO_NOTHING_CALLBACK;
        }
        DeleteTransactionCallback result = this._settings.getWorkstreamReadConfig().isPollingEnabled() ? new InvalidateNewestMessagesCallback((Iterable<DBWorkstreamMessage>)this._workstreamDAO.getEntries(ids).values()) : DeleteTransactionCallback.DO_NOTHING_CALLBACK;
        this._workstreamDAO.deleteEntriesByIds(ids);
        return result;
    }

    @Override
    public DBWorkstreamMessage getEntryByOriginAndType(ItemId originId, WorkstreamMessageType type) {
        return this._workstreamDAO.getEntryByOriginAndType(originId, type);
    }

    @Override
    public void updateModifiedAt(WorkstreamMessageId id, Date date) {
        this._workstreamDAO.updateModifiedAt(id, date);
    }

    @Override
    public void updatePinned(WorkstreamMessageId id, boolean pinned, PersonId pinAuthor, DateTime pinDate) {
        this._workstreamDAO.updatePinned(id, pinned, pinAuthor, pinDate);
    }

    @Override
    public void updatePinnedHideDate(ItemId originId, PersonId personId, DateTime hideDate) {
        this._workstreamDAO.updatePinnedHideDate(originId, personId, hideDate);
        this._pinnedHideDateCacheAccessor.invalidateKeyAndWait(new PinnedHideDateCacheKey(personId, originId));
    }

    @Override
    public DateTime getPinnedHideDate(ItemId originId, PersonId personId) {
        return (DateTime)this._pinnedHideDateCacheAccessor.getSingle(new PinnedHideDateCacheKey(personId, originId));
    }

    @Override
    public void deletePinnedHideDate(ItemId originId, PersonId personId) {
        this._workstreamDAO.deletePinnedHideDate(originId, personId);
        this._pinnedHideDateCacheAccessor.invalidateKeyAndWait(new PinnedHideDateCacheKey(personId, originId));
    }

    @Override
    public void deletePinnedHideDatesByOrigins(Set<? extends ItemId> originIds) {
        this._workstreamDAO.deletePinnedHideDatesByOrigins(originIds);
        this._pinnedHideDateCacheAccessor.invalidateAll();
    }

    @Override
    public void deletePinnedHideDatesByPersons(Set<PersonId> personIds) {
        this._workstreamDAO.deletePinnedHideDatesByPersons(personIds);
        this._pinnedHideDateCacheAccessor.invalidateAll();
    }

    @Override
    public ImmutableMap<WorkstreamMessageId, DBWorkstreamMessage> getEntries(Set<WorkstreamMessageId> typedIds) {
        return this._workstreamDAO.getEntries(typedIds);
    }

    @Override
    public DBWorkstreamMessage getMessageAttachedTo(ItemId forItem) {
        return this._workstreamDAO.getMessageAttachedTo(forItem);
    }

    @Override
    public ImmutableMap<ItemId, WorkstreamMessageId> getWorkstreamEntryIdsByAttachments(Set<? extends ItemId> attachmentIds) {
        return this._workstreamDAO.getWorkstreamEntryIdsByAttachments(attachmentIds);
    }

    @Override
    public ImmutableMap<ItemId, WorkstreamMessageId> getMicroblogEntryIdsByAttachments(Set<? extends ItemId> attachmentIds) {
        return this._workstreamDAO.getMicroblogEntryIdsByAttachments(attachmentIds);
    }

    @Override
    public ImmutableSet<WorkstreamMessageId> getWorkstreamMessageIdsByOrigins(Set<? extends ItemId> originIds) {
        return this._workstreamDAO.getWorkstreamMessageIdsByOrigins(originIds);
    }

    @Override
    public ImmutableListMultimap<WorkstreamMessageId, ItemId> getAttachedItemIds(Set<WorkstreamMessageId> ids) {
        return this._workstreamDAO.getAttachedItemIds(ids);
    }

    @Override
    public ImmutableMap<WorkstreamMessageId, Date> getNewMessagesSince(ItemId itemId, Date sinceDate, WorkstreamFilterModel filter, PersonId personId, Set<String> roles) {
        return this._workstreamDAO.getNewMessagesSince(itemId, sinceDate, filter, personId, roles);
    }

    @Override
    @Nonnull
    public ImmutableSet<WorkstreamMessageId> getAllNewMessagesByOthersSince(ItemId itemId, @Nullable Date sinceDate, WorkstreamFilterModel filter, @Nullable PersonId personId, Set<String> roles) {
        return this._workstreamDAO.getNewMessagesByOthersSince(itemId, sinceDate, filter, personId, roles);
    }

    @Override
    public void deleteAttachment(WorkstreamMessageId messageId, ItemId attachmentId) {
        this._workstreamDAO.deleteAttachment(messageId, attachmentId);
    }

    @Override
    public void updateAttachments(WorkstreamMessageId messageId, ItemId coverPictureId, ImmutableSet<ItemId> itemsToDelete, ImmutableList<? extends Attachment> attachmentsToAdd, WorkstreamDataService.AttachmentProcessorForEdits attachmentProcessor) {
        ItemId originId = ((DBWorkstreamMessage)this._workstreamDAO.getEntries((Set<WorkstreamMessageId>)ImmutableSet.of((Object)messageId)).get((Object)messageId)).getOriginItemId();
        ImmutableList<ItemId> remainingAttachmentIds = this.deleteAttachmentsAndGetRemainingIds(messageId, itemsToDelete);
        ImmutableList<? extends Attachment> attachmentsAddedToDrive = attachmentProcessor != null ? attachmentProcessor.processWithOriginId(attachmentsToAdd, originId) : attachmentsToAdd;
        Optional<DriveDocumentId> coverDocumentId = this.getPersistedCoverImageId(attachmentsAddedToDrive, coverPictureId);
        ImmutableSet.Builder attachmentUpdateBuilder = ImmutableSet.builder();
        coverDocumentId.ifPresent(arg_0 -> ((ImmutableSet.Builder)attachmentUpdateBuilder).add(arg_0));
        attachmentUpdateBuilder.addAll(remainingAttachmentIds);
        attachmentsAddedToDrive.stream().map(Attachment::getId).filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableSet.Builder)attachmentUpdateBuilder).add(arg_0));
        this._workstreamDAO.updateAttachments(messageId, (Set<ItemId>)attachmentUpdateBuilder.build());
    }

    private ImmutableList<ItemId> deleteAttachmentsAndGetRemainingIds(WorkstreamMessageId messageId, ImmutableSet<ItemId> itemsToDelete) {
        this._workstreamDAO.deleteAttachments(messageId, (Set<ItemId>)itemsToDelete);
        return (ImmutableList)this._workstreamDAO.getAttachments(messageId).stream().sorted(Comparator.comparingInt(DBWorkstreamMessageAttachment::getPosition)).map(DBWorkstreamMessageAttachment::getItemId).collect(ImmutableList.toImmutableList());
    }

    private Optional<DriveDocumentId> getPersistedCoverImageId(ImmutableList<? extends Attachment> persistedAttachments, @Nullable ItemId coverImageId) {
        if (coverImageId != null && ItemType.DRIVE_TEMP_DOCUMENT.equals(coverImageId.getType())) {
            Optional<DriveDocumentAttachment> coverAttachment = persistedAttachments.stream().filter(it -> it.getType().equals((Object)AttachmentType.DRIVE_DOCUMENT)).map(it -> (DriveDocumentAttachment)it).filter(it -> coverImageId.equals(it.getTempId())).findFirst();
            return coverAttachment.map(DriveDocumentAttachment::getId);
        }
        return Optional.ofNullable((DriveDocumentId)coverImageId);
    }

    @Override
    public ImmutableMap<EntityId, DateTime> getNewestWorkstreamDateDirect(Set<EntityId> entityIds) {
        this._workstreamReadMonitor.count(WorkstreamReadMonitor.What.NEWEST_DIRECT_REQUESTS);
        this._workstreamReadMonitor.count(WorkstreamReadMonitor.What.NEWEST_DIRECT_REQUESTS_PARAMS, entityIds.size());
        return this._newestWorkstreamDateDirectCacheAccessor.getMap(entityIds);
    }

    @Override
    public ImmutableMap<EntityId, DateTime> getNewestWorkstreamDateIndirect(Set<EntityId> entityIds) {
        this._workstreamReadMonitor.count(WorkstreamReadMonitor.What.NEWEST_INDIRECT_REQUESTS);
        this._workstreamReadMonitor.count(WorkstreamReadMonitor.What.NEWEST_INDIRECT_REQUESTS_PARAMS, entityIds.size());
        return this._newestWorkstreamDateIndirectCacheAccessor.getMap(entityIds);
    }

    @Override
    public void invalidateIndirectParents(Iterable<EntityId> changedParents) {
        this._newestWorkstreamDateIndirectCacheAccessor.invalidateKeys(changedParents);
    }

    @Override
    public void updateAttributes(WorkstreamMessageId msgId, Map<String, String> attributes) {
        this._workstreamDAO.updateAttributes(msgId, attributes);
    }

    @Override
    public ImmutableMap<WorkstreamMessageId, DBWorkstreamMessage> getMessagesForTypeAndSubject(Set<WorkstreamMessageType> types, Set<? extends ItemId> subjects) {
        return this._workstreamDAO.getMessagesForTypeAndSubject(types, subjects);
    }

    @Override
    public ImmutableMap<WorkstreamMessageId, DBWorkstreamMessage> getMessagesForTypeSubjectAndAttribute(WorkstreamMessageType type, ItemId subject, String attributeKey, String attribuateValue) {
        return this._workstreamDAO.getMessagesForTypeSubjectAndAttribute(type, subject, attributeKey, attribuateValue);
    }

    private final class InvalidateNewestMessagesCallback
    implements DeleteTransactionCallback {
        private final Set<EntityId> _directEntities;
        private final ImmutableSet<EntityId> _indirectEntities;

        private InvalidateNewestMessagesCallback(Iterable<DBWorkstreamMessage> messages) {
            this._directEntities = FluentIterable.from(messages).transform(DBWorkstreamMessage.GET_ORIGIN_ITEM_ID).filter(EntityId.class).toSet();
            this._indirectEntities = ImmutableSet.copyOf((Collection)WorkstreamDataServiceImpl.this._entityParentsDAO.getEntityParents(this._directEntities).values());
        }

        @Override
        public void afterCommit() {
            WorkstreamDataServiceImpl.this._newestWorkstreamDateDirectCacheAccessor.invalidateKeys(this._directEntities);
            WorkstreamDataServiceImpl.this._newestWorkstreamDateIndirectCacheAccessor.invalidateKeys(this._indirectEntities);
        }
    }

    @ParametersAreNonnullByDefault
    private static class PinnedHideDateCacheAccessor
    extends AbstractSingleLoadingCacheAccessor<WorkstreamEhcacheName, PinnedHideDateCacheKey, DateTime> {
        private final WorkstreamDAO _workstreamDAO;

        @ParametersAreNonnullByDefault
        PinnedHideDateCacheAccessor(EhcacheClient cache, WorkstreamDAO workstreamDAO) {
            super(cache, WorkstreamEhcacheName.PINNED_HIDE_DATE);
            this._workstreamDAO = workstreamDAO;
        }

        @Override
        protected DateTime getFromDatabaseSingle(PinnedHideDateCacheKey key) {
            return this._workstreamDAO.getPinnedHideDate(key.getOriginId(), key.getPersonId());
        }

        @Override
        protected String keyToString(PinnedHideDateCacheKey key) {
            return key.asString();
        }
    }

    @ParametersAreNonnullByDefault
    private static final class PinnedHideDateCacheKey {
        private final PersonId _personId;
        private final ItemId _originId;

        public PinnedHideDateCacheKey(PersonId personId, ItemId originId) {
            this._personId = personId;
            this._originId = originId;
        }

        @Nonnull
        public PersonId getPersonId() {
            return this._personId;
        }

        @Nonnull
        public ItemId getOriginId() {
            return this._originId;
        }

        @Nonnull
        public String asString() {
            return Long.toString(this._personId.getId()) + "#" + this._originId.asString();
        }
    }

    private static class NewestWorkstreamDateIndirectCacheAccessor
    extends AbstractMapLoadingCacheAccessor<WorkstreamEhcacheName, EntityId, DateTime> {
        private final WorkstreamDAO _workstreamDAO;
        private final WorkstreamReadMonitor _workstreamReadMonitor;

        @ParametersAreNonnullByDefault
        NewestWorkstreamDateIndirectCacheAccessor(EhcacheClient cache, WorkstreamDAO workstreamDAO, WorkstreamReadMonitor workstreamReadMonitor) {
            super(cache, WorkstreamEhcacheName.NEWEST_WORKSTREAM_DATE_INDIRECT);
            this._workstreamDAO = workstreamDAO;
            this._workstreamReadMonitor = workstreamReadMonitor;
        }

        @Override
        protected Map<? extends EntityId, ? extends DateTime> getFromDatabaseMulti(Set<? extends EntityId> inputs) {
            this._workstreamReadMonitor.count(WorkstreamReadMonitor.What.NEWEST_INDIRECT_CACHE_MISS);
            this._workstreamReadMonitor.count(WorkstreamReadMonitor.What.NEWEST_INDIRECT_CACHE_MISS_PARAMS, inputs.size());
            return this._workstreamDAO.getNewestWorkstreamDateIndirect(inputs);
        }

        @Override
        protected String keyToString(EntityId key) {
            return Long.toString(key.getId());
        }
    }

    private static class NewestWorkstreamDateDirectCacheAccessor
    extends AbstractMapLoadingCacheAccessor<WorkstreamEhcacheName, EntityId, DateTime> {
        private final WorkstreamDAO _workstreamDAO;
        private final WorkstreamReadMonitor _workstreamReadMonitor;

        @ParametersAreNonnullByDefault
        NewestWorkstreamDateDirectCacheAccessor(EhcacheClient cache, WorkstreamDAO workstreamDAO, WorkstreamReadMonitor workstreamReadMonitor) {
            super(cache, WorkstreamEhcacheName.NEWEST_WORKSTREAM_DATE_DIRECT);
            this._workstreamDAO = workstreamDAO;
            this._workstreamReadMonitor = workstreamReadMonitor;
        }

        @Override
        protected Map<? extends EntityId, ? extends DateTime> getFromDatabaseMulti(Set<? extends EntityId> inputs) {
            this._workstreamReadMonitor.count(WorkstreamReadMonitor.What.NEWEST_DIRECT_CACHE_MISS);
            this._workstreamReadMonitor.count(WorkstreamReadMonitor.What.NEWEST_DIRECT_CACHE_MISS_PARAMS, inputs.size());
            return this._workstreamDAO.getNewestWorkstreamDateDirect(inputs);
        }

        @Override
        protected String keyToString(EntityId key) {
            return Long.toString(key.getId());
        }
    }

    public static enum WorkstreamEhcacheName implements EhCacheName
    {
        NEWEST_WORKSTREAM_DATE_DIRECT,
        NEWEST_WORKSTREAM_DATE_INDIRECT,
        PINNED_HIDE_DATE;


        @Override
        public String getCacheName() {
            return this.name();
        }

        @Override
        public int getMaxElements() {
            return 2000;
        }
    }
}

