/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business.impl;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Streams;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.comments.business.CommentsService;
import de.justsoftware.onx.comments.shared.model.GenericComment;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.workstream.business.MicroblogPostingHandler;
import de.justsoftware.onx.workstream.business.WorkstreamDataService;
import de.justsoftware.onx.workstream.business.impl.AbstractWorkstreamMessageHandler;
import de.justsoftware.onx.workstream.business.impl.AttachmentCreatorService;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.attachments.Attachment;
import de.justsoftware.onx.workstream.shared.model.messages.MicroblogPosting;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="microblogPostingHandler")
public class MicroblogPostingHandlerImpl
extends AbstractWorkstreamMessageHandler<MicroblogPosting>
implements MicroblogPostingHandler {
    @Autowired
    private AttachmentCreatorService _attachmentCreatorService;
    @Autowired
    private CommentsService _commentsService;
    @Autowired
    private WorkstreamDataService _workstreamDataService;

    @Override
    public ImmutableSetMultimap<String, String> attributesToDelete(Set<? extends ItemId> itemId) {
        return ImmutableSetMultimap.of();
    }

    @Override
    public ImmutableMap<WorkstreamMessageId, MicroblogPosting> convert(Iterable<DBWorkstreamMessage> messages, Map<PersonId, PersonTeaserModel> personTeasers, ImmutableSetMultimap<Optional<WorkstreamMessageId>, Action> workstreamPermissions, AuthorizationCheckContextWithLocale authorizationContext) {
        ImmutableSet messageIds = (ImmutableSet)Streams.stream(messages).map(DBWorkstreamMessage::getId).collect(ImmutableSet.toImmutableSet());
        ImmutableListMultimap<WorkstreamMessageId, ItemId> attachmentIdsMap = this._workstreamDataService.getAttachedItemIds((Set<WorkstreamMessageId>)messageIds);
        ImmutableMap<ItemId, Attachment> attachmentMap = this._attachmentCreatorService.loadAttachments(authorizationContext, (Iterable<ItemId>)attachmentIdsMap.values());
        ImmutableSet mayComment = authorizationContext.filterAllowedIds(messageIds, StaticAction.COMMENT_CREATE);
        ImmutableMap<ItemId, ListAndCount<GenericComment>> allComments = this._commentsService.getCommentsByParentIds((Set<? extends ItemId>)messageIds, 2, false, authorizationContext);
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        for (DBWorkstreamMessage m : messages) {
            PersonId authorId = m.getAuthorId().asPersonId();
            PersonTeaserModel author = personTeasers.get(authorId);
            if (author == null) continue;
            ImmutableSet may = workstreamPermissions.get((Object)Optional.of((Object)m.getId()));
            ImmutableList attachments = (ImmutableList)attachmentIdsMap.get((Object)m.getId()).stream().map(arg_0 -> attachmentMap.get(arg_0)).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
            PersonTeaserModel editedBy = personTeasers.get(MicroblogPosting.getEditedBy(m));
            PersonTeaserModel pinAuthor = personTeasers.get(m.getPinAuthor());
            MicroblogPosting posting = new MicroblogPosting(m, author, editedBy, pinAuthor, (ImmutableSet<Action>)may, mayComment.contains((Object)m.getId()), (ImmutableList<Attachment>)attachments);
            posting.setComments((ListAndCount)Optional.fromNullable((Object)((ListAndCount)allComments.get((Object)m.getId()))).or(ListAndCount.emptyListAndCount()));
            resultBuilder.put((Object)posting.getId(), (Object)posting);
        }
        return resultBuilder.build();
    }

    @Override
    public boolean keepMessageWithNoAttachments() {
        return true;
    }
}

