/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.album.business.events.AlbumCreatedEvent;
import de.justsoftware.onx.album.business.events.ImageCreatedEvent;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.album.shared.model.DBAlbum;
import de.justsoftware.onx.album.shared.model.DBAlbumImage;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.AuthorizationContextProvider;
import de.justsoftware.onx.comments.business.events.CommentCreatedEvent;
import de.justsoftware.onx.comments.shared.model.db.DBComment;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.shared.model.EntityVersionClientModel;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.ItemService;
import de.justsoftware.onx.container.business.events.EntityCreatedEvent;
import de.justsoftware.onx.container.business.events.EntityDescriptionUpdatedEvent;
import de.justsoftware.onx.container.business.events.EntityParentsChangedByUserEvent;
import de.justsoftware.onx.container.business.events.EntityVersionPublishedEvent;
import de.justsoftware.onx.container.business.events.NewMembershipEvent;
import de.justsoftware.onx.container.shared.model.DefaultItemIdVisitor;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityVersionType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.drive.business.DriveDocumentItemHandler;
import de.justsoftware.onx.drive.business.model.DriveDocumentItem;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.like.business.LikeService;
import de.justsoftware.onx.survey.business.events.SurveyPublishedEvent;
import de.justsoftware.onx.survey.shared.model.DBSurvey;
import de.justsoftware.onx.videolink.business.events.VideolinkCreatedEvent;
import de.justsoftware.onx.videolink.shared.model.DBVideolink;
import de.justsoftware.onx.videolink.shared.model.VideolinkId;
import de.justsoftware.onx.wikieditor.business.events.NewWikiVersionEvent;
import de.justsoftware.onx.workstream.business.WorkstreamService;
import de.justsoftware.onx.workstream.business.event.MicroblogPostingSavedEvent;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.messages.ActivityWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.AlbumCreated;
import de.justsoftware.onx.workstream.shared.model.messages.AlbumImageCreated;
import de.justsoftware.onx.workstream.shared.model.messages.DriveDocumentComment;
import de.justsoftware.onx.workstream.shared.model.messages.EntityCreated;
import de.justsoftware.onx.workstream.shared.model.messages.EntityDescriptionUpdated;
import de.justsoftware.onx.workstream.shared.model.messages.EntityNewMembership;
import de.justsoftware.onx.workstream.shared.model.messages.EntityParentsChanged;
import de.justsoftware.onx.workstream.shared.model.messages.EntityVersionPublished;
import de.justsoftware.onx.workstream.shared.model.messages.ImageCommented;
import de.justsoftware.onx.workstream.shared.model.messages.SurveyPublished;
import de.justsoftware.onx.workstream.shared.model.messages.VideolinkCommented;
import de.justsoftware.onx.workstream.shared.model.messages.VideolinkCreated;
import de.justsoftware.onx.workstream.shared.model.messages.WikiVersionCreated;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="feedService")
public class FeedServiceImpl
implements ServerEventHandler {
    @Autowired
    private WorkstreamService _workstreamService;
    @Autowired
    private ItemService _itemService;
    @Autowired
    private LikeService _likeService;
    @Autowired
    private DriveDocumentItemHandler _driveDocumentService;
    @Autowired
    private AuthorizationContextProvider _authorizationContextProvider;
    @Autowired
    private EntityService _entityService;

    @Nonnull
    private Optional<EntityId> getEntityRoot(@Nonnull ItemId id) throws InvalidIDException {
        Item<?> rootItem = this._itemService.getRootItem(id);
        Object rootItemId = rootItem.getId();
        return rootItemId.accept(new DefaultItemIdVisitor<Optional<EntityId>>(){

            @Override
            public Optional<EntityId> visit(EntityId entityId) {
                return Optional.of(entityId);
            }

            @Override
            public Optional<EntityId> visitDefault(ItemId itemId) {
                return Optional.empty();
            }
        });
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onVideolinkCreated(@Nonnull VideolinkCreatedEvent e) throws InvalidIDException {
        Optional<EntityId> root;
        DBVideolink videolink = e.getVideolink();
        PersonId authorId = videolink.getAuthorId();
        this._likeService.subscribeToItems((Set<? extends ItemId>)ImmutableSet.of((Object)videolink.getId()), this._authorizationContextProvider.getAuthorizationContextForUser(authorId));
        if (e.isGenerateFeedMessage() && (root = this.getEntityRoot(videolink.getParentId())).isPresent()) {
            this.addMessageToStream(new VideolinkCreated(authorId, videolink.getId(), root.get()));
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onAlbumCreated(@Nonnull AlbumCreatedEvent e) throws InvalidIDException {
        Optional<EntityId> root;
        DBAlbum album = e.getAlbum();
        PersonId ownerId = album.getOwnerId();
        if (ownerId != null) {
            this._likeService.subscribeToItems((Set<? extends ItemId>)ImmutableSet.of((Object)album.getId()), this._authorizationContextProvider.getAuthorizationContextForUser(ownerId));
        }
        if (e.isGenerateFeedMessage() && (root = this.getEntityRoot(album.getParentId())).isPresent()) {
            this.addMessageToStream(new AlbumCreated(album.getId(), ownerId, root.get()));
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onImageCreated(@Nonnull ImageCreatedEvent e) throws InvalidIDException {
        DBAlbum album;
        Optional<EntityId> root;
        DBAlbumImage image = e.getImage();
        this._likeService.subscribeToItems((Set<? extends ItemId>)ImmutableSet.of((Object)image.getId()), this._authorizationContextProvider.getAuthorizationContextForUser(image.getOwnerId()));
        if (e.isGenerateFeedMessage() && (root = this.getEntityRoot((album = e.getAlbum()).getParentId())).isPresent()) {
            AlbumImageCreated message = new AlbumImageCreated(image.getId(), album.getId(), image.getOwnerId(), root.get());
            message.setAlbumName(album.getTitle());
            message.setImageName(image.getTitle());
            this.addMessageToStream(message);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onAddComment(@Nonnull CommentCreatedEvent e) throws InvalidIDException {
        DBComment comment = e.getComment();
        final PersonId authorId = comment.getAuthorId();
        ItemId parentId = comment.getParentId();
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForUser(authorId);
        this._likeService.subscribeToItems((Set<? extends ItemId>)ImmutableSet.of((Object)parentId), authorizationContext);
        final Optional<EntityId> root = this.getEntityRoot(parentId);
        if (root.isPresent()) {
            parentId.accept(new DefaultItemIdVisitor<Object>(){

                @Nonnull
                private Object msg(@Nonnull ActivityWorkstreamMessage message) {
                    FeedServiceImpl.this.addMessageToStream(message);
                    return this;
                }

                @Override
                public Object visit(AlbumImageId albumImageId) {
                    return this.msg(new ImageCommented(authorId, albumImageId, (GlobalId)root.get()));
                }

                @Override
                public Object visit(VideolinkId videolinkId) {
                    return this.msg(new VideolinkCommented(authorId, videolinkId, (GlobalId)root.get()));
                }

                @Override
                public Object visit(DriveDocumentId driveDocumentId) {
                    return this.msg(new DriveDocumentComment(driveDocumentId, authorId, (GlobalId)root.get(), ((DriveDocumentItem)FeedServiceImpl.this._driveDocumentService.getByIds(ImmutableSet.of((Object)driveDocumentId)).get(driveDocumentId)).getName()));
                }

                @Override
                public Object visitDefault(ItemId itemId) {
                    return this;
                }
            });
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onNewMembership(@Nonnull NewMembershipEvent e) {
        DBEntity entity = this._entityService.getById(e.getEntityId());
        if (entity != null) {
            if (e.getOptions().isUpdateSubscriptions()) {
                this._likeService.subscribeToItems((Set<? extends ItemId>)ImmutableSet.of((Object)e.getEntityId()), this._authorizationContextProvider.getAuthorizationContextForUser(e.getPersonId()));
            }
            if (e.getOptions().isEntityNewMembershipWorkstreamMessage()) {
                EntityNewMembership msg = new EntityNewMembership(e.getPersonId(), entity.getId(), entity.getName(), entity.getType());
                this.addMessageToStream(msg);
            }
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityParentsChanged(@Nonnull EntityParentsChangedByUserEvent e) {
        if (e.isSendNotifications() && !e.getNewParents().isEmpty()) {
            DBEntity entity = e.getEntity();
            this.addMessageToStream(new EntityParentsChanged(e.getAuthorId(), entity.getId(), entity.getName(), entity.getType(), e.getNewParents()));
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityCreate(@Nonnull EntityCreatedEvent e) {
        if (e.isSendNotifications()) {
            this._likeService.subscribeToItems((Set<? extends ItemId>)ImmutableSet.of((Object)e.getEntityId()), this._authorizationContextProvider.getAuthorizationContextForUser(e.getPersonId()));
            EntityCreated entry = new EntityCreated(e.getPersonId(), e.getEntityId());
            this.addMessageToStream(entry);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityDescriptionUpdated(@Nonnull EntityDescriptionUpdatedEvent e) {
        if (e.isGenerateFeedMessage()) {
            DBEntity entity = e.getEntity();
            this.addMessageToStream(new EntityDescriptionUpdated(e.getPersonId(), entity));
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onNewWikiVersion(@Nonnull NewWikiVersionEvent e) {
        if (e.isGenerateFeedMessage()) {
            this.addMessageToStream(new WikiVersionCreated(e.getAuthorId(), e.getParentEntityId(), e.getVersion()));
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onMicroblogPostingSaved(@Nonnull MicroblogPostingSavedEvent e) {
        PersonId authorId = e.getAuthorId();
        this._likeService.subscribeToItems((Set<? extends ItemId>)ImmutableSet.of((Object)e.getWorkstreamMessageId()), this._authorizationContextProvider.getAuthorizationContextForUser(authorId));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityVersionPublished(@Nonnull EntityVersionPublishedEvent e) {
        if (EntityVersionType.MAJOR.equals((Object)e.getVersion().getVersionType())) {
            DBEntity entity = this._entityService.getByIdNotNull(e.getVersion().getEntityId());
            EntityVersionPublished evc = new EntityVersionPublished(new EntityVersionClientModel(e.getVersion()), entity, e.getVersion().getAuthorId());
            this.addMessageToStream(evc);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onSurveyPublished(@Nonnull SurveyPublishedEvent e) {
        DBSurvey survey = e.getSurvey();
        GlobalId parentId = survey.getParentId();
        if (parentId instanceof EntityId) {
            SurveyPublished message = new SurveyPublished(survey.getOwnerId(), (EntityId)parentId, survey.getId());
            message.setSurveyTitle(survey.getTitle());
            this.addMessageToStream(message);
        }
    }

    @Nonnull
    private AuthorizationCheckContextWithLocale getOrCreateAuthorizationContext(@Nonnull PersonId authorId) {
        return this._authorizationContextProvider.getAuthorizationContextForUser(authorId);
    }

    @CheckForNull
    WorkstreamMessageId addMessageToStream(@Nonnull ActivityWorkstreamMessage message) {
        PersonId authorId = message.getAuthorId();
        return this._workstreamService.addMessageToStream(message, this.getOrCreateAuthorizationContext(authorId));
    }
}

