/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import de.justsoftware.onx.album.business.AlbumService;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.album.shared.model.DBAlbumImage;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.comments.business.CommentsService;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.drive.business.DriveDocumentItemHandler;
import de.justsoftware.onx.drive.business.model.DriveDocumentItem;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.like.business.LikeService;
import de.justsoftware.onx.link.business.LinkService;
import de.justsoftware.onx.link.shared.model.LinkId;
import de.justsoftware.onx.link.shared.server.model.LinkModel;
import de.justsoftware.onx.linkinfo.shared.model.LinkType;
import de.justsoftware.onx.videolink.business.VideolinkService;
import de.justsoftware.onx.videolink.shared.model.Videolink;
import de.justsoftware.onx.videolink.shared.model.VideolinkId;
import de.justsoftware.onx.workstream.business.impl.LinkAttachmentConverter;
import de.justsoftware.onx.workstream.shared.model.attachments.Attachment;
import de.justsoftware.onx.workstream.shared.model.attachments.DriveDocumentAttachment;
import de.justsoftware.onx.workstream.shared.model.attachments.ImageAttachment;
import de.justsoftware.onx.workstream.shared.model.attachments.LinkAttachment;
import de.justsoftware.onx.workstream.shared.model.attachments.PollAttachment;
import de.justsoftware.onx.workstream.shared.model.attachments.VideoLinkAttachment;
import de.justsoftware.polls.PollService;
import de.justsoftware.polls.model.Poll;
import de.justsoftware.polls.model.pollid.PollId;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="attachmentCreatorService")
public class AttachmentCreatorService {
    @Autowired
    private VideolinkService _videolinkService;
    @Autowired
    private AlbumService _albumService;
    @Autowired
    private Settings _settings;
    @Autowired
    private LikeService _likeService;
    @Autowired
    private CommentsService _commentsService;
    @Autowired
    private LinkService _linkService;
    @Autowired
    private PollService _pollService;
    @Autowired
    private DriveDocumentItemHandler _driveDocumentItemHandler;
    private final Supplier<String> _faviconSupplier = new Supplier<String>(){

        public String get() {
            return AttachmentCreatorService.this._settings.getFavIconUrl();
        }
    };

    @Nonnull
    public ImmutableMap<ItemId, Attachment> loadAttachments(@Nonnull AuthorizationCheckContextWithLocale authCtx, @Nonnull Iterable<ItemId> attachmentIds) {
        ImmutableSet pollIds;
        ImmutableMap<ItemId, Integer> likeCount = this._likeService.getLikeCount((Set<? extends ItemId>)ImmutableSet.copyOf(attachmentIds), authCtx);
        ImmutableMap<ItemId, Integer> commentCount = this._commentsService.getCommentsCounts((Set<? extends ItemId>)ImmutableSet.copyOf(attachmentIds));
        ImmutableMap.Builder attachmentBuilder = ImmutableMap.builder();
        attachmentBuilder.putAll(this.loadImageAttachments(Iterables.filter(attachmentIds, AlbumImageId.class), (Map<ItemId, Integer>)likeCount, (Map<ItemId, Integer>)commentCount));
        attachmentBuilder.putAll(this.loadVideoAttachments(authCtx, Iterables.filter(attachmentIds, VideolinkId.class), (Map<ItemId, Integer>)likeCount, (Map<ItemId, Integer>)commentCount));
        attachmentBuilder.putAll(this.loadLinkAttachments((Set<LinkId>)FluentIterable.from(attachmentIds).filter(LinkId.class).toSet()));
        attachmentBuilder.putAll(this.loadDriveAttachments((ImmutableSet<DriveDocumentId>)FluentIterable.from(attachmentIds).filter(DriveDocumentId.class).toSet(), (Map<ItemId, Integer>)likeCount, (Map<ItemId, Integer>)commentCount));
        if (this._settings.isQuickPollsEnabled() && !(pollIds = FluentIterable.from(attachmentIds).filter(PollId.class).toSet()).isEmpty()) {
            attachmentBuilder.putAll(this.loadPollAttachment((ImmutableSet<PollId>)pollIds));
        }
        return attachmentBuilder.build();
    }

    private Map<PollId, PollAttachment> loadPollAttachment(@Nonnull ImmutableSet<PollId> pollIds) {
        ImmutableMap.Builder attachmentBuilder = ImmutableMap.builder();
        pollIds.forEach(pollId -> {
            Poll poll = this._pollService.getPoll((PollId)pollId);
            if (poll != null) {
                attachmentBuilder.put((Object)poll.getId(), (Object)new PollAttachment(poll));
            }
        });
        return attachmentBuilder.build();
    }

    @Nonnull
    private Map<DriveDocumentId, DriveDocumentAttachment> loadDriveAttachments(@Nonnull ImmutableSet<DriveDocumentId> driveDocumentIds, @Nonnull Map<ItemId, Integer> likeCountMap, @Nonnull Map<ItemId, Integer> commentCountMap) {
        Map itemsById = this._driveDocumentItemHandler.getByIds(driveDocumentIds);
        ImmutableMap.Builder attachmentBuilder = ImmutableMap.builder();
        for (Map.Entry entry : itemsById.entrySet()) {
            DriveDocumentItem item = (DriveDocumentItem)entry.getValue();
            int likeCount = AttachmentCreatorService.getCountFromMap(likeCountMap, item.getId(), 0);
            int commentCount = AttachmentCreatorService.getCountFromMap(commentCountMap, item.getId(), 0);
            attachmentBuilder.put((Object)entry.getKey(), (Object)new DriveDocumentAttachment(item.getId(), item.getName(), item.getFileSize(), item.getMimeType(), likeCount, commentCount));
        }
        return attachmentBuilder.build();
    }

    @Nonnull
    private Map<LinkId, LinkAttachment> loadLinkAttachments(@Nonnull Set<LinkId> linkIds) {
        ImmutableMap<LinkId, LinkModel> linkMap = this._linkService.getByIds(linkIds);
        ImmutableSet urlsToResolve = FluentIterable.from(linkMap.values()).transform(LinkModel.TO_URL).filter((Predicate)LinkType.EXTERNAL).toSet();
        return Maps.transformValues(linkMap, (Function)new LinkAttachmentConverter());
    }

    @Nonnull
    private ImmutableMap<AlbumImageId, Attachment> loadImageAttachments(@Nonnull Iterable<AlbumImageId> albumImageIds, @Nonnull Map<ItemId, Integer> likeCountMap, @Nonnull Map<ItemId, Integer> commentCountMap) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        if (!Iterables.isEmpty(albumImageIds)) {
            ImmutableMap<AlbumImageId, DBAlbumImage> imageMap = this._albumService.getDBImagesByIds((Set<AlbumImageId>)ImmutableSet.copyOf(albumImageIds));
            for (AlbumImageId albumImageId : albumImageIds) {
                DBAlbumImage image = (DBAlbumImage)imageMap.get(albumImageId);
                if (image == null) continue;
                int likeCount = AttachmentCreatorService.getCountFromMap(likeCountMap, image.getId(), 0);
                int commentCount = AttachmentCreatorService.getCountFromMap(commentCountMap, image.getId(), 0);
                mapBuilder.put((Object)image.getId(), (Object)new ImageAttachment(image.getId(), image.getFilename(), image.getTitle(), likeCount, commentCount));
            }
        }
        return mapBuilder.build();
    }

    @Nonnull
    private ImmutableMap<VideolinkId, Attachment> loadVideoAttachments(@Nonnull AuthorizationCheckContextWithLocale authCtx, @Nonnull Iterable<VideolinkId> videoLinkIds, @Nonnull Map<ItemId, Integer> likeCountMap, @Nonnull Map<ItemId, Integer> commentCountMap) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        Map<VideolinkId, Videolink> dbMap = this._videolinkService.getVideolinksByIds((Set<VideolinkId>)ImmutableSet.copyOf(videoLinkIds), authCtx);
        for (Videolink link : dbMap.values()) {
            if (link == null) continue;
            int likeCount = AttachmentCreatorService.getCountFromMap(likeCountMap, link.getId(), 0);
            int commentCount = AttachmentCreatorService.getCountFromMap(commentCountMap, link.getId(), 0);
            mapBuilder.put((Object)link.getId(), (Object)new VideoLinkAttachment(link, likeCount, commentCount));
        }
        return mapBuilder.build();
    }

    private static int getCountFromMap(@Nonnull Map<? extends ItemId, Integer> countMap, @Nonnull ItemId keyId, int defaultValue) {
        Integer count = countMap.get(keyId);
        return count != null ? count : defaultValue;
    }
}

