/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business.impl;

import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.workstream.business.WorkstreamMessageHandler;
import de.justsoftware.onx.workstream.shared.model.messages.WorkstreamMessage;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public abstract class AbstractWorkstreamMessageHandler<W extends WorkstreamMessage>
implements WorkstreamMessageHandler<W> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWorkstreamMessageHandler.class);

    @Override
    public boolean keepMessageWithNoAttachments() {
        LOG.error("Found attachment on WorkstreamMessages of type {} which may not have any arrachments", this.getClass());
        return true;
    }

    @Nonnull
    protected static ImmutableSetMultimap<String, String> attributesToDelete(Set<? extends ItemId> itemIds, String attributeName, Class<? extends ItemId> itemIdType) {
        return (ImmutableSetMultimap)itemIds.stream().filter(itemIdType::isInstance).collect(ImmutableSetMultimap.flatteningToImmutableSetMultimap(id -> attributeName, AbstractWorkstreamMessageHandler::idAsStringStream));
    }

    @Nonnull
    private static Stream<? extends String> idAsStringStream(ItemId input) {
        if (input instanceof GlobalId) {
            return Stream.of(input.asString(), Long.toString(((GlobalId)input).getId()));
        }
        return Stream.of(input.asString());
    }
}

