/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.business.configfile.ConfFile;
import de.justsoftware.onx.common.business.configfile.ConfFilePostValidator;
import de.justsoftware.onx.common.business.configfile.LoadConfigFileException;
import de.justsoftware.onx.common.business.configfile.pathmatcher.Path;
import de.justsoftware.onx.container.business.OptionName;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterContext;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterListModel;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterModel;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum WorkstreamFilterConfValidator implements ConfFilePostValidator
{
    INSTANCE;

    private static final ImmutableSet<WorkstreamFilterContext> DEPRECATED_CONTEXTS;
    private static final ImmutableSet<WorkstreamFilterContext> ALLOWED_ON_STARTPAGE;
    private static final ImmutableSet<WorkstreamFilterContext> ALLOWED_ON_FEED;
    private static final ImmutableSet<WorkstreamFilterContext> ALLOWED_ON_ENTITY;
    private static final Logger LOGGER;

    @Override
    public void validate(ConfFile confFile) throws LoadConfigFileException {
        this.validateImpl(ItemType.STARTPAGE, Path.ANY_STARTPAGE, confFile);
        this.validateImpl(ItemType.ENTITY, Path.ANY_ENTITY, confFile);
    }

    private void validateImpl(@Nonnull ItemType parentItemType, @Nonnull Path path, @Nonnull ConfFile confFile) {
        Iterable<WorkstreamFilterListModel> filters = confFile.getAllConfigurationsFor(path, OptionName.WORKSTREAM_FILTERS);
        for (WorkstreamFilterListModel filterList : filters) {
            for (WorkstreamFilterModel filter : filterList.getFilters().values()) {
                String error = this.validateFilter(parentItemType, filter);
                if (error == null) continue;
                throw new LoadConfigFileException(error);
            }
        }
    }

    @CheckForNull
    private String validateFilter(@Nonnull ItemType parentItemType, @Nonnull WorkstreamFilterModel filter) {
        ImmutableSet<WorkstreamFilterContext> allowedContexts;
        switch (parentItemType) {
            case STARTPAGE: {
                allowedContexts = ALLOWED_ON_STARTPAGE;
                boolean profileOriginAllowed = true;
                break;
            }
            case FEED: {
                allowedContexts = ALLOWED_ON_FEED;
                boolean profileOriginAllowed = true;
                break;
            }
            case ENTITY: {
                allowedContexts = ALLOWED_ON_ENTITY;
                boolean profileOriginAllowed = false;
                break;
            }
            case PROFILE: {
                LOGGER.info("Workstreams in profiles are deprecated. Their configuration will be ignored");
                return null;
            }
            default: {
                throw new ServiceException(String.format("There can be no workstream in a %s.", parentItemType));
            }
        }
        if (!allowedContexts.contains((Object)filter.getContext())) {
            if (parentItemType.equals(ItemType.STARTPAGE) && DEPRECATED_CONTEXTS.contains((Object)filter.getContext())) {
                LOGGER.info("You used the workstream filter context {} which is deprecated. It will be ignored", (Object)filter.getContext());
                return null;
            }
            return String.format("You used the workstream filter context '%s' on a %s, which is not allowed", new Object[]{filter.getContext(), parentItemType});
        }
        return null;
    }

    public void checkWorkstreamFilterIsValid(@Nonnull ItemType parentItemType, @Nonnull WorkstreamFilterModel filter) throws ServiceException {
        String error = this.validateFilter(parentItemType, filter);
        if (error != null) {
            throw new ServiceException(error);
        }
    }

    static {
        DEPRECATED_CONTEXTS = ImmutableSet.of((Object)((Object)WorkstreamFilterContext.INDIRECT_PROFILE_SUBSCRIPTIONS));
        ALLOWED_ON_STARTPAGE = ImmutableSet.of((Object)((Object)WorkstreamFilterContext.DIRECT_SUBSCRIPTIONS), (Object)((Object)WorkstreamFilterContext.INDIRECT_ENTITY_SUBSCRIPTIONS), (Object)((Object)WorkstreamFilterContext.INDIRECT_SUBSCRIPTIONS), (Object)((Object)WorkstreamFilterContext.ALL));
        ALLOWED_ON_FEED = ImmutableSet.of((Object)((Object)WorkstreamFilterContext.DIRECT_SUBSCRIPTIONS), (Object)((Object)WorkstreamFilterContext.INDIRECT_SUBSCRIPTIONS), (Object)((Object)WorkstreamFilterContext.ALL));
        ALLOWED_ON_ENTITY = ImmutableSet.of((Object)((Object)WorkstreamFilterContext.HERE), (Object)((Object)WorkstreamFilterContext.ALL));
        LOGGER = LoggerFactory.getLogger(WorkstreamFilterConfValidator.class);
    }
}

