/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.wikieditor.shared.server.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditorId;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionId;
import de.justsoftware.onx.wikieditor.shared.server.model.AbstractDBWikiVersion;
import javax.annotation.Nonnull;

public class WikiVersionItem
implements Item<WikiVersionId> {
    public static final Function<AbstractDBWikiVersion, WikiVersionItem> FROM_DBEDITOR = new NullPermeableFunction<AbstractDBWikiVersion, WikiVersionItem>(){

        @Override
        protected WikiVersionItem applySafe(AbstractDBWikiVersion input) {
            return new WikiVersionItem(input);
        }
    };
    private final AbstractDBWikiVersion _version;

    public WikiVersionItem(@Nonnull AbstractDBWikiVersion version) {
        this._version = version;
    }

    @Nonnull
    public AbstractDBWikiVersion getVersion() {
        return this._version;
    }

    @Override
    public WikiVersionId getId() {
        return this._version.getId();
    }

    @Override
    public WikiEditorId getParentId() {
        return this._version.getWikiEditorId();
    }

    @Override
    public ComponentType getModuleType() {
        return StaticComponentType.WIKI_EDITOR;
    }

    @Override
    public <T> T accept(ItemVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", (Object)this._version).toString();
    }
}

