/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.wikieditor.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.wikieditor.integration.persistence.WikiEditorDAO;
import de.justsoftware.onx.wikieditor.shared.model.DBWikiBackup;
import de.justsoftware.onx.wikieditor.shared.model.DBWikiEditor;
import de.justsoftware.onx.wikieditor.shared.model.WikiBackupId;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditorId;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionId;
import de.justsoftware.onx.wikieditor.shared.server.model.DBWikiVersion;
import de.justsoftware.onx.wikieditor.shared.server.model.DBWikiVersionBadge;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="wikiEditorDAO")
@ParametersAreNonnullByDefault
public class IbatisWikiEditorDAO
implements WikiEditorDAO {
    private static final String NAMESPACE = "WikiEditor.";
    private final SqlMapClient _sqlMapper;
    private final IbatisStatementBuilder _ibatisBuilder;

    @Autowired
    public IbatisWikiEditorDAO(@Qualifier(value="sqlMapClient") SqlMapClient sqlMapper, StatementBuilderFactory statementBuilderFactory) {
        this._sqlMapper = sqlMapper;
        this._ibatisBuilder = statementBuilderFactory.ibatistStatementBuilder("WikiEditor");
    }

    @Override
    public void deleteWikiEditor(WikiEditorId wikiEditorId) {
        IbatisDAOUtil.wrappedDelete(this._sqlMapper, "WikiEditor.deleteWikiEditor", wikiEditorId);
    }

    @Override
    public void deleteWikiVersion(WikiVersionId id) {
        IbatisDAOUtil.wrappedDelete(this._sqlMapper, "WikiEditor.deleteWikiVersion", id);
    }

    @Override
    public void deleteWikiVersions(Iterable<WikiVersionId> ids) {
        IbatisDAOUtil.wrappedPartitionDelete(this._sqlMapper, "WikiEditor.deleteWikiVersions", ImmutableSet.copyOf(ids), IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public ImmutableMap<WikiEditorId, DBWikiVersion> getCurrentWikiVersions(Set<? extends WikiEditorId> wikiEditorIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForMap(this._sqlMapper, "WikiEditor.getCurrentWikiVersions", "wikiEditorId", wikiEditorIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public DBWikiBackup getWikiBackupById(WikiBackupId wikiBackupId) {
        return (DBWikiBackup)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, "WikiEditor.getWikiBackup", wikiBackupId);
    }

    @Override
    public DBWikiEditor getWikiEditorById(WikiEditorId id) {
        return (DBWikiEditor)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, "WikiEditor.getWikiEditorById", id);
    }

    @Override
    public ImmutableList<DBWikiEditor> getWikiEditorsByParentIds(Set<? extends GlobalId> parentIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForImmutableList(this._sqlMapper, "WikiEditor.getWikiEditorByParentIds", parentIds, GlobalId.AS_MAP_LIST);
    }

    @Override
    public ImmutableListMultimap<WikiEditorId, DBWikiVersionBadge> getWikiVersionBadgesByWikiEditorIds(Set<? extends WikiEditorId> wikiEditorIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForMultimap(this._sqlMapper, "WikiEditor.getWikiVersionBadgesByWikiEditorIds", "wikiEditorId", wikiEditorIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public ImmutableSetMultimap<WikiEditorId, WikiVersionId> getAllWikiVersionIdsByWikiEditorIds(Set<WikiEditorId> wikiEditorIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisBuilder.select("getAllWikiVersionIdsByWikiEditorIds").partition(wikiEditorIds)).asSetMultimap("wikiEditorId", "wikiVersionId");
    }

    @Override
    public WikiEditorId createWikiEditor(GlobalId parent) {
        IbatisDAOUtil.wrappedInsert(this._sqlMapper, "WikiEditor.createWikiEditor", parent.asMap());
        return ((DBWikiEditor)Iterables.getOnlyElement(this.getWikiEditorsByParentIds((Set<? extends GlobalId>)ImmutableSet.of((Object)parent)))).getId();
    }

    @Override
    public WikiVersionId insertWikiVersion(DBWikiVersion wikiVersion, Integer restoredVersion) {
        WikiEditorId wikiEditorId = wikiVersion.getWikiEditorId();
        DBWikiVersion currentVersion = (DBWikiVersion)this.getCurrentWikiVersions((Set<? extends WikiEditorId>)ImmutableSet.of((Object)wikiEditorId)).get((Object)wikiEditorId);
        int version = currentVersion == null ? 0 : currentVersion.getVersion() + 1;
        wikiVersion.setVersion(version);
        HashMap map = Maps.newHashMap();
        map.put("wikiEditorId", wikiEditorId);
        map.put("text", wikiVersion.getText());
        map.put("version", version);
        map.put("authorId", wikiVersion.getAuthorId());
        map.put("restored_version", restoredVersion);
        WikiVersionId result = (WikiVersionId)IbatisDAOUtil.wrappedInsert(this._sqlMapper, "WikiEditor.insertWikiVersion", map);
        wikiVersion.setId(result);
        return result;
    }

    @Override
    public void saveWikiBackup(DBWikiBackup wikiBackup) {
        if (this.getWikiBackupById(wikiBackup.getId()) == null) {
            IbatisDAOUtil.wrappedInsert(this._sqlMapper, "WikiEditor.insertWikiBackup", wikiBackup);
        } else {
            IbatisDAOUtil.wrappedUpdate(this._sqlMapper, "WikiEditor.updateWikiBackup", wikiBackup);
        }
    }

    @Override
    public void deleteWikiBackup(WikiBackupId id) {
        IbatisDAOUtil.wrappedDelete(this._sqlMapper, "WikiEditor.deleteWikiBackup", id);
    }

    @Override
    public Map<WikiVersionId, DBWikiVersion> getWikiVersionsByIds(Set<? extends WikiVersionId> ids) {
        return IbatisDAOUtil.wrappedPartitionQueryForMap(this._sqlMapper, "WikiEditor.getWikiVersionsByIds", "id", ids, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public void deleteWikiEditorBackups(Set<WikiEditorId> wikiEditorIds) {
        IbatisDAOUtil.wrappedPartitionDelete(this._sqlMapper, "WikiEditor.deleteWikiEditorBackups", wikiEditorIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public ImmutableSet<WikiEditorId> getWikiEditorIdWithBackupFromPersons(Set<PersonId> personIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForImmutableSet(this._sqlMapper, "WikiEditor.selectWikiEditorIdsWithBackupsForPersons", personIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }
}

