/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.wikieditor.integration.persistence;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.wikieditor.shared.model.DBWikiBackup;
import de.justsoftware.onx.wikieditor.shared.model.DBWikiEditor;
import de.justsoftware.onx.wikieditor.shared.model.WikiBackupId;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditorId;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionId;
import de.justsoftware.onx.wikieditor.shared.server.model.DBWikiVersion;
import de.justsoftware.onx.wikieditor.shared.server.model.DBWikiVersionBadge;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface WikiEditorDAO {
    @Nonnull
    public WikiEditorId createWikiEditor(@Nonnull GlobalId var1);

    public void deleteWikiEditor(WikiEditorId var1);

    public DBWikiEditor getWikiEditorById(WikiEditorId var1);

    @Nonnull
    public ImmutableList<DBWikiEditor> getWikiEditorsByParentIds(@Nonnull Set<? extends GlobalId> var1);

    @Nonnull
    public WikiVersionId insertWikiVersion(@Nonnull DBWikiVersion var1, @Nullable Integer var2);

    public void deleteWikiVersion(@Nonnull WikiVersionId var1);

    public void deleteWikiVersions(@Nonnull Iterable<WikiVersionId> var1);

    @Nonnull
    public ImmutableMap<WikiEditorId, DBWikiVersion> getCurrentWikiVersions(@Nonnull Set<? extends WikiEditorId> var1);

    @Nonnull
    public ImmutableListMultimap<WikiEditorId, DBWikiVersionBadge> getWikiVersionBadgesByWikiEditorIds(@Nonnull Set<? extends WikiEditorId> var1);

    @Nonnull
    public ImmutableSetMultimap<WikiEditorId, WikiVersionId> getAllWikiVersionIdsByWikiEditorIds(@Nonnull Set<WikiEditorId> var1);

    public void saveWikiBackup(DBWikiBackup var1);

    public DBWikiBackup getWikiBackupById(WikiBackupId var1);

    public void deleteWikiBackup(WikiBackupId var1);

    @Nonnull
    public Map<WikiVersionId, DBWikiVersion> getWikiVersionsByIds(@Nonnull Set<? extends WikiVersionId> var1);

    @Nonnull
    public ImmutableSet<WikiEditorId> getWikiEditorIdWithBackupFromPersons(@Nonnull Set<PersonId> var1);

    public void deleteWikiEditorBackups(@Nonnull Set<WikiEditorId> var1);
}

