/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.wikieditor.business.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimaps;
import de.justsoftware.onx.common.deletion.CascadeDeleteService;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.wikieditor.business.WikiEditorService;
import de.justsoftware.onx.wikieditor.business.WikiEditorVersionDeletionHandler;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditorId;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionId;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WikiEditorVersionDeletionHandlerImpl
implements WikiEditorVersionDeletionHandler {
    @Autowired
    private WikiEditorService _wikiEditorService;
    @Autowired
    private CascadeDeleteService _cascadeDeleteService;

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext deletionContext) {
        ImmutableSet wikiEditorIds = FluentIterable.from(parentIds).filter(WikiEditorId.class).toSet();
        if (CollectionUtil.isEmpty(wikiEditorIds)) {
            return;
        }
        ImmutableSetMultimap<WikiEditorId, WikiVersionId> unfilteredVersions = this._wikiEditorService.getWikiVersionIdsByWikiEditorIds((Set<WikiEditorId>)wikiEditorIds);
        ImmutableSet versionIds = deletionContext.filterItemsNotYetDeleted(unfilteredVersions.values());
        Set wikiEditorsWithDeletedVersions = Multimaps.filterValues(unfilteredVersions, (Predicate)Predicates.in(versionIds)).keySet();
        this._cascadeDeleteService.cascadeDelete((Set<? extends ItemId>)versionIds, deletionContext);
        this._wikiEditorService.deleteDependentWikiVersions((Iterable<WikiVersionId>)versionIds, wikiEditorsWithDeletedVersions, deletionContext);
    }
}

