/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.wikieditor.business.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.common.deletion.CascadeDeleteService;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.wikieditor.business.WikiEditorDeletionHandler;
import de.justsoftware.onx.wikieditor.business.WikiEditorService;
import de.justsoftware.onx.wikieditor.shared.model.DBWikiEditor;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditorId;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WikiEditorDeletionHandlerImpl
implements WikiEditorDeletionHandler {
    @Autowired
    private WikiEditorService _wikiEditorService;
    @Autowired
    private CascadeDeleteService _cascadeDeleteService;

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext deletionContext) {
        ImmutableSet personIds;
        ImmutableSet<WikiEditorId> editorIds;
        ImmutableSet entityIds = ImmutableSet.copyOf((Iterable)Iterables.filter(parentIds, EntityId.class));
        ImmutableMap<GlobalId, DBWikiEditor> editors = this._wikiEditorService.getDBWikiEditorByParentIds((Set<? extends GlobalId>)entityIds);
        for (DBWikiEditor editor : editors.values()) {
            WikiEditorId wikiEditorId = editor.getId();
            if (deletionContext.isItemDeleted(wikiEditorId)) continue;
            this._cascadeDeleteService.cascadeDelete((Set<? extends ItemId>)ImmutableSet.of((Object)wikiEditorId), deletionContext);
            this._wikiEditorService.deleteDependentWikiEditor(wikiEditorId, editor.getParentId(), deletionContext);
        }
        Iterable profileIds = Iterables.filter(parentIds, ProfileId.class);
        if (!CollectionUtil.isEmpty(profileIds) && !(editorIds = this._wikiEditorService.getWikiBackupsForPersons((Set<PersonId>)(personIds = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)profileIds, ProfileId.TO_PERSON_ID))))).isEmpty()) {
            this._wikiEditorService.deleteDependentWikiBackups((Set<WikiEditorId>)editorIds, deletionContext);
        }
    }
}

