/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.wiki.business.impl;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.searchnew.shared.model.CompoundIdStringUtil;
import de.justsoftware.onx.searchnew.shared.model.WikiInfo;
import de.justsoftware.onx.wiki.business.WikiInternalApiConnector;
import de.justsoftware.onx.wiki.shared.model.WikiId;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

@Service
@ParametersAreNonnullByDefault
public class WikiInternalApiConnectorImpl
implements WikiInternalApiConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(WikiInternalApiConnectorImpl.class);
    private final String _wikiInternalApiUrl;
    private final RestOperations _restTemplate;

    @Autowired
    public WikiInternalApiConnectorImpl(@Value(value="${just-wiki.internalApi.url}") String wikiInternalApiUrl, @Qualifier(value="defaultRestTemplate") RestOperations restTemplate) {
        this._wikiInternalApiUrl = wikiInternalApiUrl;
        this._restTemplate = restTemplate;
    }

    @Override
    public void publishAllWikiPermissions() {
        try {
            this._restTemplate.postForLocation(this._wikiInternalApiUrl + "/publish/permissions", null, new Object[0]);
        }
        catch (RestClientException e) {
            throw WikiInternalApiConnectorImpl.logAndThrow("Failed to publish all permissions.", e);
        }
    }

    @Override
    public void reindexWiki() {
        try {
            this._restTemplate.postForLocation(this._wikiInternalApiUrl + "/search/reindexAll", null, new Object[0]);
        }
        catch (RestClientException e) {
            throw WikiInternalApiConnectorImpl.logAndThrow("Failed to reindex wiki.", e);
        }
    }

    @Override
    public void reindexWikiContainers() {
        try {
            this._restTemplate.postForLocation(this._wikiInternalApiUrl + "/search/reindexWikis", null, new Object[0]);
        }
        catch (RestClientException e) {
            throw WikiInternalApiConnectorImpl.logAndThrow("Failed to reindex all wikis.", e);
        }
    }

    @Override
    public void reindexWikiChapters() {
        try {
            this._restTemplate.postForLocation(this._wikiInternalApiUrl + "/search/reindexChapters", null, new Object[0]);
        }
        catch (RestClientException e) {
            throw WikiInternalApiConnectorImpl.logAndThrow("Failed to reindex all chapters.", e);
        }
    }

    @Override
    public void reindexWikiArticles() {
        try {
            this._restTemplate.postForLocation(this._wikiInternalApiUrl + "/search/reindexArticles", null, new Object[0]);
        }
        catch (RestClientException e) {
            throw WikiInternalApiConnectorImpl.logAndThrow("Failed to reindex all articles.", e);
        }
    }

    @Override
    public boolean available() {
        try {
            this._restTemplate.getForObject(this._wikiInternalApiUrl + "/monitoring/health", String.class, new Object[0]);
            return true;
        }
        catch (RestClientException e) {
            LOGGER.error("Failed get the status of the internal wiki api", (Throwable)e);
            return false;
        }
    }

    @Override
    public void checkHealth() {
        try {
            this._restTemplate.getForObject(this._wikiInternalApiUrl + "/monitoring/health", String.class, new Object[0]);
        }
        catch (RestClientException e) {
            throw new ServiceException("Wiki health check returned status: " + e.getMessage());
        }
    }

    @Override
    @Nonnull
    public ImmutableMap<WikiId, WikiInfo> wikiInfosByIds(Set<WikiId> ids) {
        if (ids.isEmpty()) {
            return ImmutableMap.of();
        }
        try {
            HashMap result = (HashMap)this._restTemplate.postForObject(this._wikiInternalApiUrl + "/wikiNamesByIds", ids, HashMap.class, new Object[0]);
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            result.forEach((wikiIdString, s) -> {
                WikiId wikiId = new WikiId(CompoundIdStringUtil.parseStringId(wikiIdString));
                builder.put((Object)wikiId, (Object)new WikiInfo(wikiId, (String)s));
            });
            return builder.build();
        }
        catch (RestClientException e) {
            throw WikiInternalApiConnectorImpl.logAndThrow("Failed to retrieve WikiNames.", e);
        }
    }

    @Nonnull
    private static ServiceException logAndThrow(String msg, @Nullable Throwable e) {
        LOGGER.error(msg, e);
        return new ServiceException(msg + "See log for more details.", e);
    }
}

