/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.visibility.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.visibility.integration.persistence.ItemVisibilityEventDAO;
import de.justsoftware.onx.visibility.shared.model.db.DBItemVisibilityEvent;
import de.justsoftware.onx.visibility.shared.model.db.ItemVisibilityEventId;
import de.justsoftware.onx.visibility.shared.server.model.VisibilityEventType;
import de.justsoftware.toolbox.clock.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Repository
@ParametersAreNonnullByDefault
public class IbatisItemVisibilityEventDAO
implements ItemVisibilityEventDAO {
    private static final String NAMESPACE = "ItemVisibilityEvent.";
    private static final int PARTITION_SIZE_FOR_INSERT = 1000;
    private final SqlMapClient _sqlMapper;
    private final TransactionHelper _transactionHelper;
    @Autowired
    private Clock _clock;
    private final Random _random = new Random();
    private final IbatisStatementBuilder _statementBuilder;

    @Autowired
    public IbatisItemVisibilityEventDAO(@Qualifier(value="sqlMapClient") SqlMapClient sqlMapper, TransactionHelper transactionHelper, StatementBuilderFactory statementBuilderFactory) {
        this._sqlMapper = sqlMapper;
        this._transactionHelper = transactionHelper;
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("ItemVisibilityEvent");
    }

    private void insertNewEvent(GlobalId itemId, ArrayList<VisibilityEventType> eventTypes) {
        this._statementBuilder.insert("insertEvent").param("itemId", itemId, "eventTypes", eventTypes);
    }

    @Override
    public void insertNewEmptyEvent(GlobalId itemId) {
        this.insertNewEvent(itemId, new ArrayList<VisibilityEventType>());
    }

    @Override
    public void insertNewEvents(final SetMultimap<? extends GlobalId, VisibilityEventType> newEvents) {
        this._statementBuilder.batch(new IbatisStatementBuilder.BatchCallback(){

            @Override
            public void execute(SqlMapClient sqlMapClient) {
                for (Map.Entry e : newEvents.asMap().entrySet()) {
                    IbatisItemVisibilityEventDAO.this.insertNewEvent((GlobalId)e.getKey(), new ArrayList<VisibilityEventType>((Collection)e.getValue()));
                }
            }
        });
    }

    @Override
    public void insertNewEventsForMembersOfEntity(final EntityId entityId, final VisibilityEventType eventType) {
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                ImmutableList memberEventIds = IbatisDAOUtil.wrappedQueryForImmutableList(IbatisItemVisibilityEventDAO.this._sqlMapper, "ItemVisibilityEvent.getMemberEventIds", ImmutableMap.of((Object)"entityId", (Object)entityId, (Object)"roles", IbatisDAOUtil.toIbatisList(EntityMemberRoles.HAS_MEMBER_RIGHTS)));
                if (CollectionUtil.isEmpty(memberEventIds)) {
                    return;
                }
                Iterable memberEventIdsPartitions = Iterables.partition(memberEventIds, (int)1000);
                for (List memberEventIdsPartition : memberEventIdsPartitions) {
                    IbatisDAOUtil.wrappedInsert(IbatisItemVisibilityEventDAO.this._sqlMapper, "ItemVisibilityEvent.insertEventsForMembers", ImmutableMap.of((Object)"memberEventIds", (Object)memberEventIdsPartition, (Object)"itemType", (Object)ItemType.PROFILE.name(), (Object)"createDate", (Object)IbatisItemVisibilityEventDAO.this._clock.nowDate()));
                    IbatisDAOUtil.wrappedInsert(IbatisItemVisibilityEventDAO.this._sqlMapper, "ItemVisibilityEvent.insertEventTypesForMembers", ImmutableMap.of((Object)"memberEventIds", (Object)memberEventIdsPartition, (Object)"eventType", (Object)((Object)eventType)));
                }
            }
        });
    }

    @Override
    public ImmutableList<DBItemVisibilityEvent> fetchNextEvents(int itemCount) {
        Long lockId = this._random.nextLong();
        this._statementBuilder.update("markNextEventItemIds").param("count", itemCount, "lockId", lockId, "modifiedAt", this._clock.nowDate());
        return this._statementBuilder.select("selectEventsByLockId").param(lockId).asList();
    }

    @Override
    public void deleteByIds(Set<ItemVisibilityEventId> ids) {
        IbatisDAOUtil.wrappedPartitionDelete(this._sqlMapper, "ItemVisibilityEvent.deleteByIds", ids, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public void deleteAllEvents() {
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                IbatisDAOUtil.wrappedDelete(IbatisItemVisibilityEventDAO.this._sqlMapper, "ItemVisibilityEvent.deleteAllEvents");
                IbatisDAOUtil.wrappedDelete(IbatisItemVisibilityEventDAO.this._sqlMapper, "ItemVisibilityEvent.deleteQueue");
            }
        });
    }

    @Override
    public void insertForAllEntities() {
        IbatisDAOUtil.wrappedInsert(this._sqlMapper, "ItemVisibilityEvent.insertForAllEntities", ImmutableMap.of((Object)"itemType", (Object)ItemType.ENTITY, (Object)"createDate", (Object)this._clock.nowDate()));
    }

    @Override
    public void unlockStuckEvents(long minProgressDuration) {
        Date maxProgressDate = this._clock.now().minus(minProgressDuration).toDate();
        IbatisDAOUtil.wrappedUpdate(this._sqlMapper, "ItemVisibilityEvent.unlockStuckEvents", ImmutableMap.of((Object)"maxProgressDate", (Object)maxProgressDate, (Object)"modifyDate", (Object)this._clock.nowDate()));
    }

    @Override
    public int getQueueSize() {
        Integer size = (Integer)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, "ItemVisibilityEvent.getQueueSize");
        return size != null ? size : 0;
    }
}

