/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.visibility.integration.persistence.ibatis;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.visibility.integration.persistence.EntityParentsDAO;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class IbatisEntityParentsDAO
implements EntityParentsDAO {
    private final IbatisStatementBuilder _ibatisBuilder;

    @Autowired
    @ParametersAreNonnullByDefault
    public IbatisEntityParentsDAO(StatementBuilderFactory statementBuilderFactory) {
        this._ibatisBuilder = statementBuilderFactory.ibatistStatementBuilder("EntityParents");
    }

    @Override
    public ImmutableSetMultimap<EntityId, EntityId> getEntityParents(Set<? extends EntityId> entityIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisBuilder.select("getEntityParents").partition(entityIds)).asSetMultimap("entityId", "parentId");
    }

    @Override
    public void insertNewParents(final SetMultimap<EntityId, EntityId> newParents) {
        this._ibatisBuilder.batch(new IbatisStatementBuilder.BatchCallback(){

            @Override
            public void execute(SqlMapClient sqlMapClient) {
                for (Map.Entry e : newParents.entries()) {
                    IbatisEntityParentsDAO.this._ibatisBuilder.insert("insertEntityParent").param("entityId", e.getKey(), "parentId", e.getValue());
                }
            }
        });
    }

    @Override
    public void deleteParents(SetMultimap<EntityId, EntityId> deleteParents) {
        this._ibatisBuilder.delete("deleteEntityParents").partition(deleteParents.entries());
    }

    @Override
    public void deleteParentsAndChildren(Set<EntityId> deleted) {
        this._ibatisBuilder.delete("deleteEntityParentsAndChildren").partition(deleted);
    }
}

