/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.videolink.shared.model;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import javax.annotation.Nonnull;

public enum VideoHoster {
    YOUTUBE{

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitYoutube();
        }
    }
    ,
    VIMEO{

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitVimeo();
        }
    }
    ,
    SELF_HOSTED{

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitSelfHosted();
        }
    };

    public static final ImmutableSet<VideoHoster> ALL;

    @Nonnull
    public abstract <T> T accept(@Nonnull Visitor<T> var1);

    static {
        ALL = ImmutableSet.copyOf((Object[])VideoHoster.values());
    }

    public static abstract class VisitorPredicate
    implements Visitor<Boolean>,
    Predicate<VideoHoster> {
        public final boolean apply(VideoHoster input) {
            return input != null && input.accept(this) != false;
        }
    }

    public static abstract class VisitorFunction<T>
    implements Visitor<T>,
    Function<VideoHoster, T> {
        public final T apply(VideoHoster input) {
            return input != null ? (T)input.accept(this) : null;
        }
    }

    public static interface Visitor<T> {
        @Nonnull
        public T visitYoutube();

        @Nonnull
        public T visitSelfHosted();

        @Nonnull
        public T visitVimeo();
    }
}

