/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.videolink.integration.persistence.ibatis;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.videolink.integration.persistence.VideolinkDAO;
import de.justsoftware.onx.videolink.shared.model.DBVideolink;
import de.justsoftware.onx.videolink.shared.model.VideolinkId;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ibatisVideolinkDAO")
public class IbatisVideolinkDAO
implements VideolinkDAO {
    private final IbatisStatementBuilder _ibatisBuilder;

    @ParametersAreNonnullByDefault
    @Autowired
    public IbatisVideolinkDAO(StatementBuilderFactory statementBuilderFactory) {
        this._ibatisBuilder = statementBuilderFactory.ibatistStatementBuilder("MdlVideolink");
    }

    @Override
    public Map<VideolinkId, DBVideolink> getByIds(Set<VideolinkId> ids) {
        return ((IbatisPartitionResultBuilder)this._ibatisBuilder.select("getByIds").partition(ids)).asMap("id", null);
    }

    @Override
    public ImmutableSetMultimap<GlobalId, VideolinkId> getIdsByParentIds(Set<? extends GlobalId> inputs) {
        return ((IbatisPartitionResultBuilder)this._ibatisBuilder.select("getIdsByParentIds").partition(inputs)).asSetMultimap("parentId", "id");
    }

    @Override
    public VideolinkId insertVideolink(DBVideolink videolink) {
        HashMap param = Maps.newHashMap();
        param.put("parentIdId", videolink.getParentId().getId());
        param.put("parentIdType", videolink.getParentId().getType());
        param.put("title", videolink.getTitle());
        param.put("url", videolink.getUrl());
        param.put("fileName", videolink.getFileName());
        param.put("authorId", videolink.getAuthorId());
        return (VideolinkId)this._ibatisBuilder.insert("insertVideolink").param(param).orNull();
    }

    @Override
    public void updateTitle(VideolinkId id, String newTitle) {
        this._ibatisBuilder.update("updateTitle").param("id", id, "title", newTitle);
    }

    @Override
    public void updateUrl(VideolinkId id, String newURL) {
        this._ibatisBuilder.update("updateURL").param("id", id, "url", newURL);
    }

    @Override
    public void deleteByIds(Set<VideolinkId> ids) {
        this._ibatisBuilder.delete("deleteByIds").partition(ids);
    }
}

