/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.videolink.business.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.deletion.CascadeDeleteService;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.container.business.events.ItemDeletedEvent;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.videolink.business.VideolinkDeletionHandler;
import de.justsoftware.onx.videolink.business.VideolinkService;
import de.justsoftware.onx.videolink.shared.model.VideolinkId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VideolinkDeletionHandlerImpl
implements VideolinkDeletionHandler {
    @Autowired
    private VideolinkService _videolinkService;
    @Autowired
    private CascadeDeleteService _cascadeDeleteService;

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext context) {
        ImmutableSet.Builder videoIdsToDeleteBuilder = ImmutableSet.builder();
        ImmutableSet.Builder parentIdsWithVideosToDeleteBuilder = ImmutableSet.builder();
        ImmutableSet globalIds = FluentIterable.from(parentIds).filter(GlobalId.class).filter(Predicates.not((Predicate)Predicates.instanceOf(WorkstreamMessageId.class))).toSet();
        this.handleCascadeDeleteByParent((Set<? extends GlobalId>)globalIds, context, (ImmutableSet.Builder<VideolinkId>)videoIdsToDeleteBuilder, (ImmutableSet.Builder<GlobalId>)parentIdsWithVideosToDeleteBuilder);
        ImmutableSet videoIdsToDelete = videoIdsToDeleteBuilder.build();
        this._cascadeDeleteService.cascadeDelete((Set<? extends ItemId>)videoIdsToDelete, context);
        this._videolinkService.deleteDependentVideolinks((Set<VideolinkId>)videoIdsToDelete, (Set<GlobalId>)parentIdsWithVideosToDeleteBuilder.build(), context);
    }

    private void addVideolinkToContext(@Nonnull VideolinkId videolinkId, @Nonnull GlobalId parentId, @Nonnull DeletionContext context, @Nonnull ImmutableSet.Builder<VideolinkId> videoIdsToDeleteBuilder, @Nonnull ImmutableSet.Builder<GlobalId> parentIdsWithVideosToDeleteBuilder) {
        if (!context.isItemDeleted(videolinkId)) {
            videoIdsToDeleteBuilder.add((Object)videolinkId);
            parentIdsWithVideosToDeleteBuilder.add((Object)parentId);
            context.addServerEvent(new ItemDeletedEvent(videolinkId));
        }
    }

    private void handleCascadeDeleteByParent(@Nonnull Set<? extends GlobalId> globalIds, @Nonnull DeletionContext context, @Nonnull ImmutableSet.Builder<VideolinkId> videoIdsToDeleteBuilder, @Nonnull ImmutableSet.Builder<GlobalId> parentIdsWithVideosToDeleteBuilder) {
        ImmutableSetMultimap<GlobalId, VideolinkId> videoLinks = this._videolinkService.getVideolinkIdsByParentIds(globalIds);
        for (Map.Entry entry : videoLinks.entries()) {
            this.addVideolinkToContext((VideolinkId)entry.getValue(), (GlobalId)entry.getKey(), context, videoIdsToDeleteBuilder, parentIdsWithVideosToDeleteBuilder);
        }
    }
}

