/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.videolink.business;

import com.freiheit.toro.common.shared.server.storage.StorageServerHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.deletion.DeleteTransactionCallback;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.container.business.EntityModuleHandler;
import de.justsoftware.onx.container.business.ProfileModuleHandler;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.videolink.shared.model.DBVideolink;
import de.justsoftware.onx.videolink.shared.model.GwtOembedVideoData;
import de.justsoftware.onx.videolink.shared.model.Videolink;
import de.justsoftware.onx.videolink.shared.model.VideolinkId;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.json.JSONException;

public interface VideolinkService
extends EntityModuleHandler,
ProfileModuleHandler {
    @Nonnull
    public Map<VideolinkId, DBVideolink> getDBVideolinksByIds(@Nonnull Set<VideolinkId> var1);

    @Nonnull
    public Map<VideolinkId, Videolink> getVideolinksByIds(@Nonnull Set<VideolinkId> var1, @Nonnull AuthorizationCheckContextWithLocale var2);

    @CheckForNull
    public DBVideolink getDBVideolinkById(@Nonnull VideolinkId var1);

    @CheckForNull
    public Videolink getVideolink(@Nonnull VideolinkId var1, @Nonnull AuthorizationCheckContextWithLocale var2);

    public ListAndCount<Videolink> getVideolinksByParentId(GlobalId var1, int var2, int var3, @Nonnull AuthorizationCheckContextWithLocale var4);

    @Nonnull
    public ImmutableSetMultimap<GlobalId, VideolinkId> getVideolinkIdsByParentIds(@Nonnull Set<? extends GlobalId> var1);

    public int getVideoLinkCount(GlobalId var1);

    @Nonnull
    public VideolinkId insertVideolink(DBVideolink var1, boolean var2, boolean var3) throws InvalidIDException;

    public void updateTitle(VideolinkId var1, String var2);

    public void deleteVideolink(@Nonnull VideolinkId var1, @Nonnull AuthorizationCheckContextWithUserId var2);

    @Nonnull
    public DeleteTransactionCallback deleteDependentVideolinks(@Nonnull Set<VideolinkId> var1, @Nonnull Set<ItemId> var2);

    public void deleteDependentVideolinks(@Nonnull Set<VideolinkId> var1, @Nonnull Set<GlobalId> var2, @Nonnull DeletionContext var3);

    @CheckForNull
    public Videolink getNewestVideolink(@Nonnull GlobalId var1, @Nonnull AuthorizationCheckContextWithLocale var2);

    public void updateUrl(VideolinkId var1, String var2, @Nonnull AuthorizationCheckContextWithLocale var3);

    @CheckForNull
    public GwtOembedVideoData getBaseData(String var1) throws JSONException;

    @VisibleForTesting
    public void setStorageServerHelper(@Nonnull StorageServerHelper var1);
}

