/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.util.server;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.outerj.daisy.diff.HtmlCleaner;
import org.outerj.daisy.diff.html.HTMLDiffer;
import org.outerj.daisy.diff.html.HtmlSaxDiffOutput;
import org.outerj.daisy.diff.html.TextNodeComparator;
import org.outerj.daisy.diff.html.dom.DomTree;
import org.outerj.daisy.diff.html.dom.DomTreeBuilder;
import org.outerj.daisy.diff.output.DiffOutput;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class HtmlDiffUtil {
    @Nonnull
    public static String htmlDiff(@Nonnull String oldVersion, @Nonnull String newVersion) throws TransformerConfigurationException, SAXException, IOException {
        HtmlCleaner cleaner = new HtmlCleaner();
        TextNodeComparator leftComparator = HtmlDiffUtil.getComparator(cleaner, oldVersion);
        TextNodeComparator rightComparator = HtmlDiffUtil.getComparator(cleaner, newVersion);
        StringWriter writer = new StringWriter();
        SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        TransformerHandler result = tf.newTransformerHandler();
        result.setResult(new StreamResult(writer));
        result.startDocument();
        HtmlSaxDiffOutput output = new HtmlSaxDiffOutput((ContentHandler)result, "diff");
        HTMLDiffer differ = new HTMLDiffer((DiffOutput)output);
        differ.diff(leftComparator, rightComparator);
        result.endDocument();
        return writer.toString().replaceAll("(?i)<iframe([^<>]*?)/>", "<iframe$1></iframe>");
    }

    @Nonnull
    private static TextNodeComparator getComparator(@Nonnull HtmlCleaner cleaner, @Nonnull String htmlString) throws IOException, SAXException {
        InputSource source = new InputSource(new StringReader(htmlString));
        DomTreeBuilder handler = new DomTreeBuilder();
        cleaner.cleanAndParse(source, (ContentHandler)handler);
        return new TextNodeComparator((DomTree)handler, Locale.getDefault());
    }
}

