/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.util.server;

import de.justsoftware.onx.util.shared.DocumentUtil;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class DocumentUtilServer
implements DocumentUtil {
    private final DecimalFormat _df;

    public DocumentUtilServer(Locale loc) {
        this._df = (DecimalFormat)NumberFormat.getNumberInstance(loc);
    }

    @Override
    public String getHumanReadableSize(long size) {
        String ret;
        if ((double)size < 1024.0) {
            ret = size + " bytes";
        } else if ((double)size < 1048576.0) {
            this._df.applyPattern("#");
            ret = this._df.format((double)size / 1024.0) + " kB";
        } else {
            this._df.applyPattern("#.#");
            ret = this._df.format((double)size / 1048576.0) + " MB";
        }
        return ret;
    }
}

