/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.util.server;

import de.justsoftware.onx.util.server.JucoSecurityException;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.annotation.Nonnull;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class AESUtil {
    private AESUtil() {
    }

    @Nonnull
    private static Cipher createAndInitCipher(int opmode, @Nonnull byte[] secretKey, @Nonnull byte[] initializationVector) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(opmode, (Key)new SecretKeySpec(secretKey, "AES"), new IvParameterSpec(initializationVector));
        return cipher;
    }

    @Nonnull
    static byte[] encrypt(@Nonnull byte[] plainBytes, @Nonnull byte[] secretKey, @Nonnull byte[] initializationVector) {
        try {
            return AESUtil.createAndInitCipher(1, secretKey, initializationVector).doFinal(plainBytes);
        }
        catch (GeneralSecurityException e) {
            throw new JucoSecurityException(e);
        }
    }

    @Nonnull
    static byte[] decrypt(@Nonnull byte[] encrypted, @Nonnull byte[] secretKey, @Nonnull byte[] initializationVector) {
        try {
            return AESUtil.createAndInitCipher(2, secretKey, initializationVector).doFinal(encrypted);
        }
        catch (GeneralSecurityException e) {
            throw new JucoSecurityException(e);
        }
    }
}

