/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.util.server;

import de.justsoftware.onx.util.server.AESKeyProvider;
import de.justsoftware.onx.util.server.AESUtil;
import de.justsoftware.onx.util.server.AbstractEncoderDecoder;
import de.justsoftware.onx.util.server.JucoSecurityException;
import de.justsoftware.onx.util.server.SecureRandomUtil;
import javax.annotation.Nonnull;
import org.apache.commons.lang.ArrayUtils;

public final class AESRandomIvEncodeDecoder
extends AbstractEncoderDecoder<byte[], byte[]> {
    public static final int AES_KEY_LEN = 16;
    private final AESKeyProvider _secretKey;

    public AESRandomIvEncodeDecoder(@Nonnull AESKeyProvider secretKey) {
        this._secretKey = secretKey;
    }

    @Override
    public byte[] encode(byte[] plain) {
        byte[] iv = SecureRandomUtil.randomBytes(16);
        byte[] encrypted = AESUtil.encrypt(plain, this._secretKey.getKey(), iv);
        return ArrayUtils.addAll((byte[])iv, (byte[])encrypted);
    }

    @Override
    public byte[] decode(byte[] encoded) {
        if (encoded.length < 16) {
            throw new JucoSecurityException("key is too short");
        }
        byte[] iv = ArrayUtils.subarray((byte[])encoded, (int)0, (int)16);
        byte[] encrypted = ArrayUtils.subarray((byte[])encoded, (int)16, (int)encoded.length);
        return AESUtil.decrypt(encrypted, this._secretKey.getKey(), iv);
    }
}

