/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.usergroup.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import de.justsoftware.onx.container.shared.model.AbstractUUIDBasedId;
import de.justsoftware.onx.container.shared.model.IdParseException;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class UserGroupId
extends AbstractUUIDBasedId {
    public static final String USER_GROUP_TYPE = "USER_GROUP";
    private static final long serialVersionUID = 1L;
    private static final String USER_GROUP_TYPE_SEPARATOR = ",";
    private static final String USER_GROUP_PREFIX = "USER_GROUP,";

    @Deprecated
    public UserGroupId() {
    }

    public UserGroupId(UUID uuid) {
        super(uuid);
    }

    @Nonnull
    public static Optional<UserGroupId> parse(@Nullable String s) {
        if (s == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(UserGroupId.parseOrThrow(s));
        }
        catch (IdParseException e) {
            return Optional.empty();
        }
    }

    @Nonnull
    @JsonCreator
    public static UserGroupId parseOrThrow(String s) {
        String trimmed = s.trim();
        if (!trimmed.startsWith(USER_GROUP_PREFIX)) {
            throw new IdParseException(String.format("Input '%s' has wrong format. Must be of format '%sUUID'", s, USER_GROUP_PREFIX));
        }
        try {
            return new UserGroupId(UUID.fromString(trimmed.substring(USER_GROUP_PREFIX.length())));
        }
        catch (IllegalArgumentException e) {
            throw new IdParseException(e);
        }
    }

    @Nonnull
    public static UserGroupId fromString(String s) {
        String normalizedId = s.replace(USER_GROUP_PREFIX, "").strip();
        return new UserGroupId(UUID.fromString(normalizedId));
    }

    @Override
    @JsonValue
    public String toString() {
        return USER_GROUP_PREFIX + this.getId();
    }
}

