/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.usergroup.business.impl;

import com.freiheit.toro.cache.CacheClient;
import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.util.CollectingServerEventCollector;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.cache.AbstractMultiMapCacheAccessor;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.usergroup.business.UserGroupDeletionHandler;
import de.justsoftware.onx.usergroup.event.UserGroupMemberAddedEvent;
import de.justsoftware.onx.usergroup.event.UserGroupMemberRemovedEvent;
import de.justsoftware.onx.usergroup.integration.persistence.ibatis.IbatisUserGroupDAO;
import de.justsoftware.onx.usergroup.model.UserGroup;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import de.justsoftware.permission.client.model.AuthorizationResult;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class UserGroupService {
    private final PermissionRequestConnector _permissionRequestConnector;
    private final IbatisUserGroupDAO _userGroupDAO;
    private final TransactionHelper _transactionHelper;
    private final List<UserGroupDeletionHandler> _deletionHandlers;
    private final UserGroupMembersUserGroupByIdCacheAccessor _userGroupMembersUserGroupByIdCacheAccessor;
    private final JCEventBus _jcEventBus;

    @Autowired
    public UserGroupService(PermissionRequestConnector permissionRequestConnector, TransactionHelper transactionHelper, IbatisUserGroupDAO userGroupDAO, EhcacheClient ehCacheClient, JCEventBus jcEventBus, List<UserGroupDeletionHandler> deletionHandlers) {
        this._permissionRequestConnector = permissionRequestConnector;
        this._transactionHelper = transactionHelper;
        this._userGroupDAO = userGroupDAO;
        this._jcEventBus = jcEventBus;
        this._deletionHandlers = deletionHandlers;
        this._userGroupMembersUserGroupByIdCacheAccessor = new UserGroupMembersUserGroupByIdCacheAccessor(ehCacheClient, userGroupDAO);
    }

    public void addOrUpdateUserGroup(UserGroup group) {
        this._userGroupDAO.upsertUserGroup(group);
    }

    public void removeUserGroup(UserGroupId groupId) {
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        this._transactionHelper.doInTransactionWithoutResult(status -> {
            this._deletionHandlers.forEach(handler -> handler.handleCascadeDelete(groupId, eventCollector));
            this._userGroupDAO.deleteUserGroup(groupId);
        });
        this._userGroupMembersUserGroupByIdCacheAccessor.invalidateKey(groupId);
        eventCollector.fireEvents(this._jcEventBus);
    }

    public void addUserGroupMemberships(ImmutableSetMultimap<UserGroupId, PersonId> membersToAdd, ServerEventCollector eventCollector) {
        if (membersToAdd.isEmpty()) {
            return;
        }
        this._transactionHelper.doInTransactionWithoutResult(status -> {
            membersToAdd.forEach(this._userGroupDAO::upsertUserGroupMembership);
            membersToAdd.keySet().forEach(this._userGroupDAO::updateUserGroupModifiedAt);
        });
        this._userGroupMembersUserGroupByIdCacheAccessor.invalidateKeysAndWait(membersToAdd.keySet());
        eventCollector.add(new UserGroupMemberAddedEvent(membersToAdd));
    }

    public void removeUserGroupMemberships(ImmutableSetMultimap<UserGroupId, PersonId> membersToRemove, ServerEventCollector eventCollector) {
        if (membersToRemove.isEmpty()) {
            return;
        }
        this._transactionHelper.doInTransactionWithoutResult(status -> {
            membersToRemove.forEach(this._userGroupDAO::deleteUserGroupMembership);
            membersToRemove.keySet().forEach(this._userGroupDAO::updateUserGroupModifiedAt);
        });
        this._userGroupMembersUserGroupByIdCacheAccessor.invalidateKeysAndWait(membersToRemove.keys());
        eventCollector.add(new UserGroupMemberRemovedEvent(membersToRemove));
    }

    @Nonnull
    public ImmutableMap<UserGroupId, UserGroup> getUserGroupsByIds(ImmutableSet<UserGroupId> userGroupIds) {
        return this._userGroupDAO.getUserGroupsByIds(userGroupIds);
    }

    @Nonnull
    public ImmutableSetMultimap<UserGroupId, PersonId> getUserGroupMembersByIds(ImmutableSet<UserGroupId> userGroupIds) {
        return (ImmutableSetMultimap)this._userGroupMembersUserGroupByIdCacheAccessor.getMultiMap(userGroupIds);
    }

    public void checkReadUserGroups(ImmutableSet<UserGroupId> userGroupIds, PersonId reader) throws PermissionDeniedException {
        Set<Role> readRoles = this.readRoles((Set<UserGroupId>)userGroupIds);
        ImmutableMap authResults = this._permissionRequestConnector.hasRoles(readRoles, this.profileRoleSet(reader));
        readRoles.forEach(readRole -> {
            if (authResults.get(readRole) != AuthorizationResult.OK) {
                throw new PermissionDeniedException(String.format("%s is not allowed", readRole));
            }
        });
    }

    @Nonnull
    private Set<Role> readRoles(Set<UserGroupId> userGroupIds) {
        return userGroupIds.stream().map(this::readRole).collect(Collectors.toSet());
    }

    @Nonnull
    private Role readRole(UserGroupId userGroupId) {
        return Role.read((String)Role.userGroupRole((UUID)userGroupId.getId()).asString());
    }

    @Nonnull
    private Set<Role> profileRoleSet(PersonId personId) {
        return ImmutableSet.of((Object)Role.profileRole((long)personId.getId()));
    }

    @Nonnull
    public Set<UserGroupId> filterUserGroupsWithRoleRead(Set<UserGroupId> userGroupIds, PersonId reader) {
        ImmutableMap authResults = this._permissionRequestConnector.hasRoles(this.readRoles(userGroupIds), this.profileRoleSet(reader));
        return userGroupIds.stream().filter(userGroupId -> authResults.get((Object)this.readRole((UserGroupId)userGroupId)) == AuthorizationResult.OK).collect(Collectors.toSet());
    }

    @Nonnull
    public Set<UserGroupId> filterUserGroupsByMembership(Set<UserGroupId> userGroupIds, PersonId memberId) {
        return ((ImmutableSetMultimap)this._userGroupMembersUserGroupByIdCacheAccessor.getMultiMap(userGroupIds)).entries().stream().filter(entry -> memberId.equals(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @CheckForNull
    public UserGroup getAllUsersGroup(TenantId tenantId) {
        return this._userGroupDAO.getAllUsersGroup(tenantId);
    }

    @VisibleForTesting
    public void updateUserGroupModifiedAt(UserGroupId userGroupId, DateTime modifiedAt) {
        this._userGroupDAO.updateUserGroupModifiedAt(userGroupId, modifiedAt);
    }

    @ParametersAreNonnullByDefault
    private static class UserGroupMembersUserGroupByIdCacheAccessor
    extends AbstractMultiMapCacheAccessor<UserGroupEhCacheName, UserGroupId, PersonId, Map.Entry<UserGroupId, PersonId>, ImmutableSetMultimap<UserGroupId, PersonId>, ImmutableSetMultimap.Builder<UserGroupId, PersonId>, ImmutableSet<PersonId>> {
        private final IbatisUserGroupDAO _userGroupDAO;

        protected UserGroupMembersUserGroupByIdCacheAccessor(CacheClient<? super UserGroupEhCacheName> cache, IbatisUserGroupDAO userGroupDAO) {
            super(cache, UserGroupEhCacheName.USER_GROUP_MEMBER_BY_USER_GROUP_ID);
            this._userGroupDAO = userGroupDAO;
        }

        @Override
        protected String keyToString(UserGroupId key) {
            return key.toString();
        }

        @Override
        protected PersonId objectToValue(Map.Entry<UserGroupId, PersonId> dbResult) {
            return dbResult.getValue();
        }

        @Override
        protected ImmutableSet<PersonId> get(ImmutableSetMultimap<UserGroupId, PersonId> map, UserGroupId input) {
            return map.get((Object)input);
        }

        @Override
        protected ImmutableSetMultimap<UserGroupId, PersonId> build(ImmutableSetMultimap.Builder<UserGroupId, PersonId> builder) {
            return builder.build();
        }

        @Override
        protected ImmutableSetMultimap.Builder<UserGroupId, PersonId> createBuilder() {
            return ImmutableSetMultimap.builder();
        }

        @Override
        @CheckForNull
        protected UserGroupId objectToKey(Map.Entry<UserGroupId, PersonId> dbResult) {
            return dbResult.getKey();
        }

        @Override
        protected Iterable<Map.Entry<UserGroupId, PersonId>> getListFromDatabase(Set<? extends UserGroupId> inputs) {
            return this._userGroupDAO.getUserGroupMembersByIds((ImmutableSet<UserGroupId>)ImmutableSet.copyOf(inputs)).entries();
        }
    }

    public static enum UserGroupEhCacheName implements EhCacheName
    {
        USER_GROUP_MEMBER_BY_USER_GROUP_ID("UserGroupMember.userGroupId");

        private final String _prefix;

        private UserGroupEhCacheName(String prefix) {
            this._prefix = prefix;
        }

        @Override
        public String getCacheName() {
            return this._prefix;
        }
    }
}

