/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tenantdesign.model;

import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.container.shared.model.TenantId;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Theme {
    private final TenantId _tenantId;
    private final String _globalHighlightColor;
    @Nullable
    private final String _logoId;
    private final Map<CoreApp, String> _appColors;

    public Theme(TenantId tenantId, String globalHighlightColor, @Nullable String logoId, Map<CoreApp, String> appColors) {
        this._tenantId = tenantId;
        this._globalHighlightColor = globalHighlightColor;
        this._logoId = logoId;
        this._appColors = appColors;
    }

    @Nonnull
    public TenantId getTenantId() {
        return this._tenantId;
    }

    @Nonnull
    public String getGlobalHighlightColor() {
        return this._globalHighlightColor;
    }

    @Nullable
    public String getLogoId() {
        return this._logoId;
    }

    @Nonnull
    public Map<CoreApp, String> getAppColors() {
        return this._appColors;
    }

    public String toString() {
        return "Theme{_tenantId=" + this._tenantId + ", _globalHighlightColor='" + this._globalHighlightColor + "', _logoId='" + this._logoId + "', _appColors=" + this._appColors + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Theme theme = (Theme)o;
        if (!this._tenantId.equals(theme._tenantId)) {
            return false;
        }
        if (!this._globalHighlightColor.equals(theme._globalHighlightColor)) {
            return false;
        }
        if (!Objects.equals(this._logoId, theme._logoId)) {
            return false;
        }
        return this._appColors.equals(theme._appColors);
    }

    public int hashCode() {
        int result = this._tenantId.hashCode();
        result = 31 * result + this._globalHighlightColor.hashCode();
        result = 31 * result + (this._logoId != null ? this._logoId.hashCode() : 0);
        result = 31 * result + this._appColors.hashCode();
        return result;
    }
}

