/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tenant.integration.persistence.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.tenant.integration.persistence.model.DBTenantModel;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Tenant
implements Serializable {
    private static final long serialVersionUID = 1L;
    private TenantId _id;
    private String _name;
    private String _logoId;
    private String _deeplKey;

    @Deprecated
    public Tenant() {
    }

    public Tenant(TenantId id, String name) {
        this(id, name, null);
    }

    public Tenant(TenantId id, String name, @Nullable String logoId) {
        this(id, name, logoId, null);
    }

    public Tenant(TenantId id, String name, @Nullable String logoId, @Nullable String deeplKey) {
        this._id = id;
        this._name = name;
        this._logoId = logoId;
        this._deeplKey = deeplKey;
    }

    @Nonnull
    public TenantId getId() {
        return this._id;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @CheckForNull
    public String getLogoId() {
        return this._logoId;
    }

    @CheckForNull
    public String getDeeplKey() {
        return this._deeplKey;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("name", (Object)this._name).add("logoId", (Object)this._logoId).add("deeplKey", (Object)this._deeplKey).toString();
    }

    @Nonnull
    private Object[] hashObjects() {
        return new Object[]{this._id, this._name, this._logoId, this._deeplKey};
    }

    public int hashCode() {
        return Arrays.hashCode(this.hashObjects());
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Tenant && Arrays.equals(this.hashObjects(), ((Tenant)obj).hashObjects());
    }

    public static Tenant fromDBModel(DBTenantModel dbTenantModel) {
        return new Tenant(dbTenantModel.getId(), dbTenantModel.getName(), dbTenantModel.getLogoId(), dbTenantModel.getDeeplKey());
    }
}

