/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tenant.integration.persistence.ibatis;

import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.tenant.integration.persistence.TenantDAO;
import de.justsoftware.onx.tenant.integration.persistence.model.Tenant;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class IbatisTenantDAO
implements TenantDAO {
    private final IbatisStatementBuilder _statementBuilder;

    @Autowired
    public IbatisTenantDAO(StatementBuilderFactory statementBuilderFactory) {
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("Tenant");
    }

    @Override
    public Tenant upsert(TenantId tenantId, String name, @Nullable String logoId, @Nullable String deeplKey) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantId", tenantId);
        params.put("name", name);
        params.put("logoId", logoId);
        params.put("deeplKey", deeplKey);
        this._statementBuilder.insertDbSpecific("upsertTenant").param(params);
        return this.get(tenantId).orElseThrow();
    }

    @Override
    public Optional<Tenant> get(TenantId tenantId) {
        Optional dbModel = ((IbatisStandardResultBuilder)this._statementBuilder.select("getTenant").param("tenantId", tenantId)).asOptional();
        return dbModel.map(Tenant::fromDBModel);
    }

    @Override
    public void delete(TenantId tenantId) {
        this._statementBuilder.delete("deleteTenant").param(tenantId);
    }

    @Override
    public int forAllTenants(Consumer<TenantId> consumer) {
        return ((IbatisStandardResultBuilder)this._statementBuilder.select("forAllTenants").noParam()).executeWithConsumer(consumer);
    }

    @Override
    public List<TenantId> getAllTenants() {
        return ((IbatisStandardResultBuilder)this._statementBuilder.select("getAllTenants").noParam()).asList();
    }
}

