/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tenant.integration.persistence.ibatis;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.tenant.integration.persistence.PersonTenantDAO;
import de.justsoftware.onx.tenant.integration.persistence.model.Tenant;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class IbatisPersonTenantDAO
implements PersonTenantDAO {
    private static final String PERSON_ID = "personId";
    private static final String TENANT_ID = "tenantId";
    private final IbatisStatementBuilder _statementBuilder;

    @Autowired
    public IbatisPersonTenantDAO(StatementBuilderFactory statementBuilderFactory) {
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("PersonTenant");
    }

    @Override
    public void addTenantToPerson(PersonId personId, TenantId tenantId) {
        this._statementBuilder.insertDbSpecific("create").param(PERSON_ID, personId, TENANT_ID, tenantId);
    }

    @Override
    public void addTenantToPersons(TenantId tenantId, Set<PersonId> personIds) {
        this._statementBuilder.batch(sqlMapClient -> personIds.forEach(personId -> this.addTenantToPerson((PersonId)personId, tenantId)));
    }

    @Override
    public ImmutableSet<TenantId> getPersonTenantIds(PersonId personId) {
        return this.getPersonTenantIds((Set<PersonId>)ImmutableSet.of((Object)personId)).get((Object)personId);
    }

    @Override
    @Nonnull
    public ImmutableSetMultimap<PersonId, TenantId> getPersonTenantIds(Set<PersonId> personIds) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("getPersonTenantIds").partition(personIds)).asSetMultimap("person_id", "tenant_id");
    }

    @Override
    public void delete(PersonId personId, TenantId tenantId) {
        this._statementBuilder.delete("deletePersonTenant").param(PERSON_ID, personId, TENANT_ID, tenantId);
    }

    @Override
    public void deleteForPerson(PersonId personId) {
        this._statementBuilder.delete("deleteForPerson").param(personId);
    }

    @Override
    public ImmutableSet<PersonId> getPersonIdsForTenant(TenantId tenantId) {
        return this._statementBuilder.select("getPersonIdsForTenant").param(tenantId).asSet();
    }

    @Override
    public void deleteForTenant(TenantId tenantId) {
        this._statementBuilder.delete("deleteForTenant").param(tenantId);
    }

    @Override
    public ImmutableSet<Tenant> getPersonTenants(PersonId personId) {
        ImmutableSet personTenants = this._statementBuilder.select("getPersonTenants").param(personId).asSet();
        return (ImmutableSet)personTenants.stream().map(Tenant::fromDBModel).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public ImmutableSet<PersonId> filterPersonsByTenantMembership(ImmutableSet<PersonId> personsToFilter, TenantId tenantId) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("filterPersonsByTenantMembership").partition("personsToFilter", personsToFilter, (Map<String, ?>)ImmutableMap.of((Object)TENANT_ID, (Object)tenantId))).asSet();
    }
}

