/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tenant.integration.kafka.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.container.shared.model.TenantId;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TenantKafkaModel {
    private final TenantId _id;
    private final String _name;
    private final String _invitationCode;
    private final TenantKafkaTheme _theme;
    private final String _deeplKey;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public TenantKafkaModel(@JsonProperty(value="id", required=true) TenantId id, @JsonProperty(value="name", required=true) String name, @JsonProperty(value="invitationCode") String invitationCode, @JsonProperty(value="theme") TenantKafkaTheme theme, @JsonProperty(value="deeplKey") String deeplKey) {
        this._id = id;
        this._name = name;
        this._invitationCode = invitationCode;
        this._theme = theme;
        this._deeplKey = deeplKey;
    }

    @Nonnull
    public TenantId getId() {
        return this._id;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    public String getInvitationCode() {
        return this._invitationCode;
    }

    public TenantKafkaTheme getTheme() {
        return this._theme;
    }

    public String getDeeplKey() {
        return this._deeplKey;
    }

    public String toString() {
        return "TenantKafkaModel{_id=" + this._id + ", _name='" + this._name + "', _invitationCode='" + this._invitationCode + "', _theme=" + this._theme + "}";
    }

    public ImmutableMap<String, String> getTenantColors() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Optional.ofNullable(this._theme.getAdminColor()).ifPresent(val -> builder.put((Object)"APP_COLOR_ADMIN", val));
        Optional.ofNullable(this._theme.getChatColor()).ifPresent(val -> builder.put((Object)"APP_COLOR_CHAT", val));
        Optional.ofNullable(this._theme.getConnectColor()).ifPresent(val -> builder.put((Object)"APP_COLOR_CONNECT", val));
        Optional.ofNullable(this._theme.getDriveColor()).ifPresent(val -> builder.put((Object)"APP_COLOR_DRIVE", val));
        Optional.ofNullable(this._theme.getListColor()).ifPresent(val -> builder.put((Object)"APP_COLOR_TASKS", val));
        Optional.ofNullable(this._theme.getWikiColor()).ifPresent(val -> builder.put((Object)"APP_COLOR_WIKI", val));
        Optional.ofNullable(this._theme.getPeopleColor()).ifPresent(val -> builder.put((Object)"APP_COLOR_PEOPLE", val));
        Optional.ofNullable(this._theme.getNewsColor()).ifPresent(val -> builder.put((Object)"APP_COLOR_NEWS", val));
        Optional.ofNullable(this._theme.getHighlightColor()).ifPresent(val -> builder.put((Object)"GLOBAL_HIGHLIGHT_COLOR", val));
        return builder.build();
    }

    public static class TenantKafkaTheme {
        private final String _logoId;
        private final String _adminColor;
        private final String _wikiColor;
        private final String _connectColor;
        private final String _chatColor;
        private final String _listColor;
        private final String _peopleColor;
        private final String _driveColor;
        private final String _newsColor;
        private final String _highlightColor;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public TenantKafkaTheme(@JsonProperty(value="TENANT_LOGO_ID") String logoId, @JsonProperty(value="APP_COLOR_ADMIN") String adminColor, @JsonProperty(value="APP_COLOR_CHAT") String chatColor, @JsonProperty(value="APP_COLOR_CONNECT") String connectColor, @JsonProperty(value="APP_COLOR_DRIVE") String driveColor, @JsonProperty(value="APP_COLOR_TASKS") String listColor, @JsonProperty(value="APP_COLOR_NEWS") String newsColor, @JsonProperty(value="APP_COLOR_PEOPLE") String peopleColor, @JsonProperty(value="APP_COLOR_WIKI") String wikiColor, @JsonProperty(value="GLOBAL_HIGHLIGHT_COLOR") String highlightColor) {
            this._logoId = logoId;
            this._adminColor = adminColor;
            this._wikiColor = wikiColor;
            this._newsColor = newsColor;
            this._connectColor = connectColor;
            this._chatColor = chatColor;
            this._listColor = listColor;
            this._peopleColor = peopleColor;
            this._driveColor = driveColor;
            this._highlightColor = highlightColor;
        }

        public String getLogoId() {
            return this._logoId;
        }

        public String getAdminColor() {
            return this._adminColor;
        }

        public String getWikiColor() {
            return this._wikiColor;
        }

        public String getConnectColor() {
            return this._connectColor;
        }

        public String getChatColor() {
            return this._chatColor;
        }

        public String getListColor() {
            return this._listColor;
        }

        public String getPeopleColor() {
            return this._peopleColor;
        }

        public String getDriveColor() {
            return this._driveColor;
        }

        public String getNewsColor() {
            return this._newsColor;
        }

        public String getHighlightColor() {
            return this._highlightColor;
        }
    }
}

