/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tenant.business.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.person.integration.persistence.PersonDAO;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.tenant.business.PersonTenantService;
import de.justsoftware.onx.tenant.integration.kafka.PersonTenantPublisher;
import de.justsoftware.onx.tenant.integration.persistence.PersonTenantDAO;
import de.justsoftware.onx.tenant.integration.persistence.model.Tenant;
import de.justsoftware.permission.client.kafka.SingleRoleAssignmentProducer;
import de.justsoftware.permission.client.kafka.WaitForOffsets;
import de.justsoftware.permission.client.model.Role;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class PersonTenantServiceImpl
implements PersonTenantService {
    private static final int CHUNK_SIZE = 100;
    private final SingleRoleAssignmentProducer _roleProducer;
    private final PersonTenantDAO _personTenantDAO;
    private final PersonTenantPublisher _personTenantPublisher;
    private final PersonDAO _personDAO;

    @Autowired
    public PersonTenantServiceImpl(SingleRoleAssignmentProducer roleProducer, PersonTenantDAO personTenantDAO, PersonTenantPublisher personTenantPublisher, PersonDAO personDAO) {
        this._roleProducer = roleProducer;
        this._personTenantDAO = personTenantDAO;
        this._personTenantPublisher = personTenantPublisher;
        this._personDAO = personDAO;
    }

    @Override
    public WaitForOffsets addPersonToTenant(PersonId personId, TenantId tenantId) {
        this._personTenantDAO.addTenantToPerson(personId, tenantId);
        this._personTenantPublisher.publishPersonTenants(personId, (Set<TenantId>)this._personTenantDAO.getPersonTenantIds(personId));
        return this._roleProducer.addRoleReplacement(Role.tenantRole((UUID)tenantId.getId()), Role.profileRole((long)personId.getId()));
    }

    @Override
    public WaitForOffsets deletePersonFromTenant(PersonId personId, TenantId tenantId) {
        this._personTenantDAO.delete(personId, tenantId);
        this._personTenantPublisher.publishPersonTenants(personId, (Set<TenantId>)this._personTenantDAO.getPersonTenantIds(personId));
        return this._roleProducer.deleteRoleReplacement(Role.tenantRole((UUID)tenantId.getId()), Role.profileRole((long)personId.getId()));
    }

    @Override
    public void republishAllPersonTenants() {
        this._personTenantPublisher.republish(() -> this._personDAO.forAllPersonsChunked(100, persons -> {
            Set<PersonId> personIds = persons.stream().map(DBPerson::getId).collect(Collectors.toSet());
            ImmutableSetMultimap<PersonId, TenantId> personTenantsMap = this._personTenantDAO.getPersonTenantIds(personIds);
            personTenantsMap.keySet().forEach(personId -> this._personTenantPublisher.publishPersonTenants((PersonId)personId, (Set<TenantId>)personTenantsMap.get(personId)));
        }));
        this._roleProducer.republish(Role::isTenantRole, () -> this._personDAO.forAllPersonsChunked(100, persons -> {
            Set<PersonId> personIds = persons.stream().map(DBPerson::getId).collect(Collectors.toSet());
            ImmutableSetMultimap<PersonId, TenantId> personTenantsMap = this._personTenantDAO.getPersonTenantIds(personIds);
            personTenantsMap.keySet().forEach(personId -> {
                ImmutableSet personTenants = personTenantsMap.get(personId);
                personTenants.forEach(tenantId -> this._roleProducer.addRoleReplacement(Role.tenantRole((UUID)tenantId.getId()), Role.profileRole((long)personId.getId())));
            });
        }));
    }

    @Override
    public ImmutableSet<TenantId> getTenantIdsForPerson(PersonId personId) {
        return this._personTenantDAO.getPersonTenantIds(personId);
    }

    @Override
    public ImmutableSetMultimap<PersonId, TenantId> getTenantIdsForPersons(Set<PersonId> personIds) {
        return this._personTenantDAO.getPersonTenantIds(personIds);
    }

    @Override
    public void addTenantIdToEntityMembers(ImmutableList<EntityMemberWithPerson> entityMembers, TenantId tenantId) {
        this._personTenantDAO.addTenantToPersons(tenantId, (Set)entityMembers.stream().map(EntityMemberWithPerson::getPersonId).collect(ImmutableSet.toImmutableSet()));
    }

    @Override
    public void addTenantIdToAllPersons(TenantId tenantId) {
        this._personDAO.forAllPersonsChunked(100, dbPersons -> this._personTenantDAO.addTenantToPersons(tenantId, (Set)dbPersons.stream().map(DBPerson::getId).collect(ImmutableSet.toImmutableSet())));
    }

    @Override
    public void deletePersonTenantsForPerson(PersonId personId, DeletionContext deletionContext) {
        ImmutableSet<TenantId> tenantIds = this.getTenantIdsForPerson(personId);
        deletionContext.attach(() -> {
            tenantIds.forEach(tenantId -> this._roleProducer.deleteRoleReplacement(Role.tenantRole((UUID)tenantId.getId()), Role.profileRole((long)personId.getId())));
            this._personTenantPublisher.publishPersonTenants(personId, Set.of());
        });
        this._personTenantDAO.deleteForPerson(personId);
    }

    @Override
    public void deletePersonTenantsForTenant(TenantId tenantId, DeletionContext deletionContext) {
        ImmutableSet<PersonId> personIdsForTenants = this._personTenantDAO.getPersonIdsForTenant(tenantId);
        deletionContext.attach(() -> {
            personIdsForTenants.forEach(personId -> this._roleProducer.deleteRoleReplacement(Role.tenantRole((UUID)tenantId.getId()), Role.profileRole((long)personId.getId())));
            personIdsForTenants.stream().forEach(personId -> this._personTenantPublisher.publishPersonTenants((PersonId)personId, (Set<TenantId>)this._personTenantDAO.getPersonTenantIds((PersonId)personId)));
        });
        this._personTenantDAO.deleteForTenant(tenantId);
    }

    @Override
    public ImmutableSet<Tenant> getPersonTenants(PersonId id) {
        return this._personTenantDAO.getPersonTenants(id);
    }

    @Override
    public boolean areAllPersonsMembersOfTenant(ImmutableSet<PersonId> personIds, TenantId tenantId) {
        return personIds.size() == this._personTenantDAO.filterPersonsByTenantMembership(personIds, tenantId).size();
    }
}

