/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tenant.business;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.tenant.integration.persistence.model.Tenant;
import de.justsoftware.permission.client.kafka.WaitForOffsets;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface PersonTenantService {
    public void republishAllPersonTenants();

    public WaitForOffsets addPersonToTenant(PersonId var1, TenantId var2);

    @Nonnull
    public ImmutableSet<TenantId> getTenantIdsForPerson(PersonId var1);

    @Nonnull
    public ImmutableSetMultimap<PersonId, TenantId> getTenantIdsForPersons(Set<PersonId> var1);

    public void addTenantIdToEntityMembers(ImmutableList<EntityMemberWithPerson> var1, TenantId var2);

    public void addTenantIdToAllPersons(TenantId var1);

    public WaitForOffsets deletePersonFromTenant(PersonId var1, TenantId var2);

    public void deletePersonTenantsForPerson(PersonId var1, DeletionContext var2);

    public void deletePersonTenantsForTenant(TenantId var1, DeletionContext var2);

    public ImmutableSet<Tenant> getPersonTenants(PersonId var1);

    public boolean areAllPersonsMembersOfTenant(ImmutableSet<PersonId> var1, TenantId var2);
}

