/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tasks.shared.model;

import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.tasks.shared.model.StaticTaskFilterIds;
import de.justsoftware.onx.tasks.shared.model.SubtasksFilterId;
import de.justsoftware.onx.tasks.shared.model.TaskFilterId;
import de.justsoftware.onx.tasks.shared.model.TaskId;
import de.justsoftware.onx.tasks.shared.model.TaskListFilterId;
import de.justsoftware.onx.tasks.shared.model.TaskListId;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TaskFilterIds {
    @Nonnull
    public static final TaskFilterId fromString(@Nullable String s) throws FilterIdParseException {
        if (s == null) {
            throw new FilterIdParseException(null);
        }
        for (StaticTaskFilterIds filterId : StaticTaskFilterIds.values()) {
            if (!filterId.asString().equals(s)) continue;
            return filterId;
        }
        ItemId itemId = ItemId.parseSafe(s);
        if (itemId instanceof TaskListId) {
            return new TaskListFilterId((TaskListId)itemId);
        }
        if (itemId instanceof TaskId) {
            return new SubtasksFilterId((TaskId)itemId);
        }
        throw new FilterIdParseException(s);
    }

    public static class FilterIdParseException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public FilterIdParseException(@Nullable String idStr) {
            super("Could not parse TaskFilterId: " + idStr);
        }
    }
}

