/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tasks.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.base.MoreObjects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.authorization.business.ProfileRole;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.Creator;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.AbstractUUIDBasedItemId;
import de.justsoftware.onx.tasks.authorization.TaskRight;
import de.justsoftware.onx.tasks.business.model.TaskBO;
import de.justsoftware.onx.tasks.business.model.TaskFilter;
import de.justsoftware.onx.tasks.business.model.TaskListBO;
import de.justsoftware.onx.tasks.integration.persistence.TaskCreateModel;
import de.justsoftware.onx.tasks.integration.persistence.TaskDAO;
import de.justsoftware.onx.tasks.integration.persistence.ibatis.TaskDBModel;
import de.justsoftware.onx.tasks.shared.model.TaskId;
import de.justsoftware.onx.tasks.shared.model.TaskListId;
import de.justsoftware.onx.tasks.shared.model.TaskStatus;
import de.justsoftware.toolbox.clock.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class IbatisTaskDAO
implements TaskDAO {
    private final IbatisStatementBuilder _statementBuilder;
    private final Clock _clock;
    private final TransactionHelper _transactionHelper;

    @Autowired
    public IbatisTaskDAO(StatementBuilderFactory statementBuilderFactory, Clock clock, TransactionHelper transactionHelper) {
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("Tasks");
        this._clock = clock;
        this._transactionHelper = transactionHelper;
    }

    @Nonnull
    private static TaskBO dbToTaskBO(TaskDBModel db) {
        AbstractUUIDBasedItemId parentId = db.getTaskListId() != null ? db.getTaskListId() : db.getParentTaskId();
        return new TaskBO(db.getId(), db.getName(), db.getDescription(), db.getOwnerId(), db.getAssigneeId(), db.getStatus(), parentId, db.getCreateDate(), db.getAttachmentName(), db.getAttachmentUrl(), db.getDueDate());
    }

    @Nonnull
    private static TaskListBO dbToTaskListBO(Object obj) {
        return new TaskListBO((TaskListId)IbatisDAOUtil.probe(obj, "id"), (String)IbatisDAOUtil.probe(obj, "name"));
    }

    @Nonnull
    private static TaskListId dbToTaskListId(Object obj) {
        return (TaskListId)IbatisDAOUtil.probe(obj, "id");
    }

    @Override
    public TaskId createTask(TaskCreateModel task) {
        this._statementBuilder.insert("insertTask").param(task);
        return task.getId();
    }

    @Override
    public ImmutableSet<TaskId> createTasks(final Iterable<TaskCreateModel> tasks) {
        final ImmutableSet.Builder idBuilder = ImmutableSet.builder();
        this._statementBuilder.batch(new IbatisStatementBuilder.BatchCallback(){

            @Override
            public void execute(SqlMapClient sqlMapClient) {
                for (TaskCreateModel task : tasks) {
                    idBuilder.add((Object)IbatisTaskDAO.this.createTask(task));
                }
            }
        });
        return idBuilder.build();
    }

    @Override
    public ImmutableMap<TaskId, TaskBO> getTasksByIds(Set<TaskId> ids) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("selectTasksByIds").partition(ids)).asMap(TaskDBModel::getId, IbatisTaskDAO::dbToTaskBO);
    }

    @Override
    public void setStatus(Set<TaskId> ids, TaskStatus status) {
        this._statementBuilder.update("updateStatus").partition("ids", ids, "status", (Object)status, "modifyDate", this._clock.nowDate());
    }

    @Override
    public void setName(TaskId id, String name) {
        this._statementBuilder.update("updateName").param("name", name, "id", id, "modifyDate", this._clock.nowDate());
    }

    @Override
    public void deleteTasksAndSubtasks(Set<TaskId> ids) {
        this._statementBuilder.delete("deleteTasksAndSubtasks").partition(ids);
    }

    @Override
    public void setDescription(TaskId id, String description) {
        this._statementBuilder.update("updateDescription").param("description", description, "id", id, "modifyDate", this._clock.nowDate());
    }

    @Override
    public void setDueDate(TaskId id, DateTime dueDate) {
        HashMap params = Maps.newHashMap();
        params.put("id", id);
        params.put("dueDate", dueDate);
        params.put("modifyDate", this._clock.nowDate());
        this._statementBuilder.update("updateDueDate").param(params);
    }

    @Override
    public void setAssignee(TaskId taskId, PersonId assigneeId) {
        HashMap params = Maps.newHashMap();
        params.put("id", taskId);
        params.put("assigneeId", assigneeId);
        params.put("modifyDate", this._clock.nowDate());
        this._statementBuilder.update("updateAssignee").param(params);
    }

    @Override
    public ImmutableSet<TaskId> getTaskIdsByTaskFilter(TaskFilter filter) {
        return ((IbatisStandardResultBuilder)this._statementBuilder.select("selectTaskIdsByFilter").param("filter", filter)).asSet();
    }

    @Override
    public ImmutableMap<TaskId, Long> getTaskPositions(String taskFilterId, Set<TaskId> tasks) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("getTaskPositionsByFilter").partition("tasks", tasks, "taskFilterId", taskFilterId)).asMap("task_id", "position");
    }

    @Override
    public void indexTasks(TaskFilter filter) {
        Long start = (Long)((IbatisStandardResultBuilder)this._statementBuilder.select("getTaskFilterStart").param("filter", filter)).asObject();
        this._statementBuilder.insert("indexTasks").param("filter", filter, "start", MoreObjects.firstNonNull((Object)start, (Object)0L));
    }

    @Override
    public void moveTasks(TaskFilter filter, long taskPositon, long targetPosition) {
        this._statementBuilder.update("setFilterPositionUniqueDeferred").noParam();
        if (taskPositon < targetPosition) {
            this._statementBuilder.update("moveUp").param("lower", taskPositon, "upper", targetPosition, "filter", filter);
        } else if (taskPositon > targetPosition) {
            this._statementBuilder.update("moveDown").param("lower", targetPosition, "upper", taskPositon, "filter", filter);
        }
        this._statementBuilder.update("setFilterPositionUniqueImmediate").noParam();
    }

    @Override
    public ImmutableList<TaskBO> getTasksByTaskFilter(TaskFilter filter, int skip, int max) {
        return ((IbatisStandardResultBuilder)this._statementBuilder.select("selectTasksByFilter").param("filter", filter)).limit(skip, max).transform(IbatisTaskDAO::dbToTaskBO).toList();
    }

    @Override
    public ImmutableMultiset<TaskStatus> getTaskCountByStatus(TaskFilter filter) {
        return ((IbatisStandardResultBuilder)this._statementBuilder.select("selectTaskStatusCountsByFilter").param("filter", filter)).asMultiset("status", "count");
    }

    @Override
    public void setTaskFilterOrder(String taskFilterId, ImmutableSet<TaskId> taskIds) {
        this._transactionHelper.doInTransactionWithoutResult(status -> this._statementBuilder.batch(s -> {
            this._statementBuilder.delete("deleteTaskOrderForFilter").param(taskFilterId);
            long i = 0L;
            for (TaskId taskId : taskIds) {
                this.insertTaskPosition(taskFilterId, taskId, i);
                ++i;
            }
        }));
    }

    @Override
    public void insertTaskPosition(String taskFilterId, TaskId taskId, long position) {
        this._statementBuilder.insert("insertTaskFilterPosition").param("taskfilterId", taskFilterId, "taskId", taskId, "position", position);
    }

    @Override
    public void deleteTaskPosition(String taskFilterId, TaskId taskId) {
        this._statementBuilder.delete("deleteTaskFilterPosition").param("taskfilterId", taskFilterId, "taskId", taskId);
    }

    @Override
    public ImmutableSetMultimap<TaskId, PersonId> filterSubtaskAssignees(SetMultimap<TaskId, PersonId> tasksAndPersons) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("filterSubtaskAssignees").partition(tasksAndPersons.entries())).asSetMultimap("task", "person");
    }

    @Override
    public ImmutableSetMultimap<TaskId, PersonId> filterSubtaskOwners(SetMultimap<TaskId, PersonId> tasksAndPersons) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("filterSubtaskOwners").partition(tasksAndPersons.entries())).asSetMultimap("task", "person");
    }

    @Override
    public void insertTaskList(TaskListId id, String name, Map<ProfileRole, TaskRight> permissions) {
        this._transactionHelper.doInTransactionWithoutResult(status -> this._statementBuilder.batch(s -> {
            this._statementBuilder.insert("insertTaskList").param("id", id, "name", name);
            permissions.forEach((role, right) -> this._statementBuilder.insert("insertTaskListPermission").param("task_list_id", id, "role", role.getName(), "right", right));
        }));
    }

    @Override
    public void deleteTaskLists(Set<TaskListId> ids) {
        this._statementBuilder.delete("deleteTaskLists").partition(ids);
    }

    @Override
    public ImmutableList<TaskListBO> getTaskListsWithRoles(Set<ProfileRole> roles) {
        return this._statementBuilder.select("getTaskListsWithRoles").param(FluentIterable.from(roles).transform(Creator::getName).toList()).asList(IbatisTaskDAO::dbToTaskListBO);
    }

    @Override
    public ImmutableMap<TaskListId, TaskListBO> getTaskListsByIds(Set<TaskListId> ids) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("getTaskListsByIds").partition(ids)).asMap(IbatisTaskDAO::dbToTaskListId, IbatisTaskDAO::dbToTaskListBO);
    }

    @CheckForNull
    private static final ProfileRole getProfileRole(Object obj) {
        String role = (String)IbatisDAOUtil.probe(obj, "role");
        if (role == null) {
            return null;
        }
        return ProfileRole.parse(role);
    }

    @Override
    public ImmutableTable<TaskListId, ProfileRole, TaskRight> getTaskListPermissions(Set<TaskListId> taskListIds) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("getTaskListPermissions").partition(taskListIds)).asTable(IbatisDAOUtil.singlePropertyFunction("task_list_id"), IbatisTaskDAO::getProfileRole, IbatisDAOUtil.singlePropertyFunction("task_right"));
    }

    @Override
    public void updateTaskList(TaskListId id, String name, Map<ProfileRole, TaskRight> permissions) {
        this._transactionHelper.doInTransactionWithoutResult(status -> this._statementBuilder.batch(s -> {
            this._statementBuilder.insert("updateTaskListName").param("id", id, "name", name);
            permissions.forEach((role, right) -> this._statementBuilder.insertDbSpecific("addTaskListPermission").param("task_list_id", id, "role", role.getName(), "right", right));
            permissions.forEach((role, right) -> this._statementBuilder.insert("updateTaskListPermission").param("task_list_id", id, "role", role.getName(), "right", right));
            ImmutableList roles = FluentIterable.from(permissions.keySet()).transform(Creator::getName).toList();
            this._statementBuilder.delete("deleteTaskListPermissionRolesNotIn").param("task_list_id", id, "roles", roles);
        }));
    }

    @Override
    public ImmutableTable<TaskListId, ProfileRole, TaskRight> filterTaskListPermissions(SetMultimap<TaskListId, ProfileRole> roles) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("filterTaskListPermissions").partition(roles.entries())).asTable(IbatisDAOUtil.singlePropertyFunction("task_list_id"), IbatisTaskDAO::getProfileRole, IbatisDAOUtil.singlePropertyFunction("task_right"));
    }

    @Override
    public void reorderTasks(TaskFilter filter, TaskId taskId, TaskId targetTaskId) {
        this._transactionHelper.doInTransactionWithoutResult(status -> {
            long targetPosition;
            ImmutableMap<TaskId, Long> positions = this.getPositions(filter, (Set<TaskId>)ImmutableSet.of((Object)taskId, (Object)targetTaskId));
            long taskPositon = (Long)positions.get((Object)taskId);
            if (taskPositon == (targetPosition = ((Long)positions.get((Object)targetTaskId)).longValue())) {
                throw new IllegalStateException("tasks (" + taskId + "," + targetPosition + ") have same positions in filter " + filter.getTaskFilterId() + "!");
            }
            this._statementBuilder.batch(sqlMapClient -> {
                this.deleteTaskPosition(filter.getTaskFilterId(), taskId);
                this.moveTasks(filter, taskPositon, targetPosition);
                this.insertTaskPosition(filter.getTaskFilterId(), taskId, targetPosition);
            });
        });
    }

    @Nonnull
    private ImmutableMap<TaskId, Long> getPositions(TaskFilter filter, Set<TaskId> taskIds) {
        ImmutableMap<TaskId, Long> positions = this.getTaskPositions(filter.getTaskFilterId(), taskIds);
        Sets.SetView missingTasks = Sets.difference(taskIds, (Set)positions.keySet());
        if (missingTasks.isEmpty()) {
            return positions;
        }
        this.indexTasks(filter);
        ImmutableMap<TaskId, Long> positionsAfterUpdate = this.getTaskPositions(filter.getTaskFilterId(), taskIds);
        Sets.SetView missingTasksAfterUpdate = Sets.difference(taskIds, (Set)positionsAfterUpdate.keySet());
        if (missingTasksAfterUpdate.isEmpty()) {
            return positionsAfterUpdate;
        }
        throw new IllegalStateException("can not find tasks in filter");
    }
}

