/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tasks.integration.persistence;

import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.tasks.shared.model.TaskGetters;
import de.justsoftware.onx.tasks.shared.model.TaskId;
import de.justsoftware.onx.tasks.shared.model.TaskListId;
import de.justsoftware.onx.tasks.shared.model.TaskStatus;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public final class TaskCreateModel
implements TaskGetters {
    final TaskId _id;
    final PersonId _ownerId;
    PersonId _assigneeId;
    String _name = "";
    String _description = "";
    TaskStatus _status = TaskStatus.OPEN;
    TaskId _parentTaskId;
    DateTime _createDate;
    String _attachmentName = "";
    String _attachmentUrl = "";
    TaskListId _taskListId;

    private TaskCreateModel(TaskId id, PersonId ownerId, DateTime createDate) {
        this._id = id;
        this._ownerId = ownerId;
        this._createDate = createDate;
    }

    @Nonnull
    @VisibleForTesting
    public static TaskCreateModel createForTests(TaskId id, PersonId ownerId, DateTime createDate) {
        return new TaskCreateModel(id, ownerId, createDate);
    }

    @Nonnull
    public static TaskCreateModel create(PersonId ownerId, DateTime createDate) {
        return new TaskCreateModel(TaskId.random(), ownerId, createDate);
    }

    @Nonnull
    @VisibleForTesting
    public static TaskCreateModel createForTests(PersonId ownerId) {
        return TaskCreateModel.create(ownerId, new DateTime());
    }

    @Override
    public TaskId getId() {
        return this._id;
    }

    @Nonnull
    public TaskCreateModel setName(String name) {
        this._name = name;
        return this;
    }

    @Nonnull
    public TaskCreateModel setDescription(String description) {
        this._description = description;
        return this;
    }

    @Nonnull
    public TaskCreateModel setAssignee(@Nullable PersonId assigneeId) {
        this._assigneeId = assigneeId;
        return this;
    }

    @Nonnull
    public TaskCreateModel setStatus(TaskStatus status) {
        this._status = status;
        return this;
    }

    @Nonnull
    public TaskCreateModel setTaskListId(@Nullable TaskListId taskListId) {
        this._taskListId = taskListId;
        return this;
    }

    @Override
    public PersonId getOwnerId() {
        return this._ownerId;
    }

    @Override
    public PersonId getAssigneeId() {
        return this._assigneeId;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public TaskStatus getStatus() {
        return this._status;
    }

    @CheckForNull
    public TaskId getParentTaskId() {
        return this._parentTaskId;
    }

    @Nonnull
    public TaskCreateModel setParentTaskId(@Nullable TaskId parentTaskId) {
        this._parentTaskId = parentTaskId;
        return this;
    }

    @Nonnull
    public DateTime getCreateDate() {
        return this._createDate;
    }

    @Override
    public String getAttachmentName() {
        return this._attachmentName;
    }

    @Nonnull
    public TaskCreateModel setAttachmentName(String attachmentName) {
        this._attachmentName = attachmentName;
        return this;
    }

    @Override
    public String getAttachmentUrl() {
        return this._attachmentUrl;
    }

    @Nonnull
    public TaskCreateModel setAttachmentUrl(String attachmentUrl) {
        this._attachmentUrl = attachmentUrl;
        return this;
    }

    @CheckForNull
    public TaskListId getTaskListId() {
        return this._taskListId;
    }
}

