/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tasks.business.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.AbstractImmutableEqualsObject;
import de.justsoftware.onx.tasks.shared.model.TaskId;
import de.justsoftware.onx.tasks.shared.model.TaskListId;
import de.justsoftware.onx.tasks.shared.model.TaskStatus;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TaskFilter
extends AbstractImmutableEqualsObject {
    private final String _taskFilterId;
    private final PersonId _assigneeId;
    private final PersonId _ownerId;
    private final TaskStatus _status;
    private final TaskId _parentTaskId;
    private final TaskListId _taskListId;

    public TaskFilter(String taskFilterId, @Nullable PersonId assigneeId, @Nullable PersonId ownerId, @Nullable TaskStatus status, @Nullable TaskId parentTaskId, @Nullable TaskListId taskListId) {
        super(new Object[]{taskFilterId, assigneeId, ownerId, status, parentTaskId, taskListId});
        this._taskFilterId = taskFilterId;
        this._assigneeId = assigneeId;
        this._ownerId = ownerId;
        this._status = status;
        this._parentTaskId = parentTaskId;
        this._taskListId = taskListId;
    }

    @CheckForNull
    public PersonId getAssigneeId() {
        return this._assigneeId;
    }

    @CheckForNull
    public PersonId getOwnerId() {
        return this._ownerId;
    }

    @CheckForNull
    public TaskStatus getStatus() {
        return this._status;
    }

    @CheckForNull
    public TaskId getParentTaskId() {
        return this._parentTaskId;
    }

    @CheckForNull
    public TaskListId getTaskListId() {
        return this._taskListId;
    }

    @Nonnull
    public String getTaskFilterId() {
        return this._taskFilterId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("taskFilterId", (Object)this._taskFilterId).add("assigneeId", (Object)this._assigneeId).add("ownerId", (Object)this._ownerId).add("parentTaskId", (Object)this._parentTaskId).add("status", (Object)this._status).toString();
    }

    @ParametersAreNonnullByDefault
    public static interface MinimumTaskFilterBuilder {
        @Nonnull
        public TaskFilterBuilder withOwner(PersonId var1);

        @Nonnull
        public TaskFilterBuilder withParentTask(TaskId var1);

        @Nonnull
        public TaskFilterBuilder withAssignee(PersonId var1);

        @Nonnull
        public TaskFilterBuilder withTaskListId(TaskListId var1);
    }

    @ParametersAreNonnullByDefault
    public static final class TaskFilterBuilder
    implements MinimumTaskFilterBuilder {
        private final String _taskFilterId;
        private PersonId _assigneeId = null;
        private PersonId _ownerId = null;
        private TaskStatus _status = null;
        private TaskId _parentTaskId = null;
        private TaskListId _taskListId = null;

        private TaskFilterBuilder(String taskFilterId) {
            this._taskFilterId = taskFilterId;
        }

        @Nonnull
        public static MinimumTaskFilterBuilder forTaskFilterId(String taskFilterId) {
            return new TaskFilterBuilder(taskFilterId);
        }

        @Override
        public TaskFilterBuilder withOwner(PersonId ownerId) {
            this._ownerId = ownerId;
            return this;
        }

        @Nonnull
        public TaskFilterBuilder withStatus(TaskStatus status) {
            this._status = status;
            return this;
        }

        @Override
        public TaskFilterBuilder withAssignee(PersonId assignee) {
            this._assigneeId = assignee;
            return this;
        }

        @Override
        public TaskFilterBuilder withParentTask(TaskId parentTaskId) {
            this._parentTaskId = parentTaskId;
            return this;
        }

        @Override
        public TaskFilterBuilder withTaskListId(TaskListId taskListId) {
            this._taskListId = taskListId;
            return this;
        }

        @Nonnull
        public TaskFilter build() {
            return new TaskFilter(this._taskFilterId, this._assigneeId, this._ownerId, this._status, this._parentTaskId, this._taskListId);
        }
    }
}

