/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tasks.business.impl;

import de.justsoftware.onx.tasks.business.TaskFilterLockService;
import de.justsoftware.onx.tasks.business.model.TaskFilterLockedException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class TaskFilterLockServiceImpl
implements TaskFilterLockService {
    private static final Logger LOG = LoggerFactory.getLogger(TaskFilterLockServiceImpl.class);
    private static final String ZOOKEEPER_PATH_PREFIX = "/just/task/filterLock/";
    private final CuratorFramework _zookeeperClient;
    private final int _timeOutSeconds;
    private final int _numberOfLocks;

    @Autowired
    public TaskFilterLockServiceImpl(CuratorFramework zookeeperClient, @Value(value="${just.task.filterLock.timeout:10}") int timeOutSeconds, @Value(value="${just.task.filterLock.lockcount:101}") int lockcount) {
        this._zookeeperClient = zookeeperClient;
        this._timeOutSeconds = Math.max(timeOutSeconds, 1);
        this._numberOfLocks = Math.max(lockcount, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R acquireAndExecute(@Nullable String taskFilterId, Supplier<R> f) {
        boolean lockAquired;
        InterProcessMutex mutex = new InterProcessMutex(this._zookeeperClient, ZOOKEEPER_PATH_PREFIX + this.lockId(taskFilterId));
        try {
            lockAquired = mutex.acquire((long)this._timeOutSeconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.warn("Catched Excpetion while aquiring lock for task filter " + taskFilterId + ", ignoring the lock, but expect errors!", (Throwable)e);
            return f.get();
        }
        if (!lockAquired) {
            throw new TaskFilterLockedException();
        }
        try {
            R r = f.get();
            return r;
        }
        finally {
            try {
                mutex.release();
            }
            catch (Exception e) {
                LOG.warn("Catched Exception during release of lock for task filter " + taskFilterId + ", expect further errors!", (Throwable)e);
            }
        }
    }

    private int lockId(@Nullable String taskFilterId) {
        if (taskFilterId == null) {
            return 0;
        }
        return taskFilterId.hashCode() % this._numberOfLocks;
    }
}

