/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tasks.business;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.tasks.authorization.TaskAction;
import de.justsoftware.onx.tasks.authorization.TaskAuthorizationContext;
import de.justsoftware.onx.tasks.business.model.TaskBO;
import de.justsoftware.onx.tasks.shared.model.TaskFilterId;
import de.justsoftware.onx.tasks.shared.model.TaskId;
import de.justsoftware.onx.tasks.shared.model.TaskStatus;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public interface TaskService {
    public void setAssignee(TaskId var1, @Nullable PersonId var2, TaskAuthorizationContext var3);

    @Nonnull
    public ImmutableMap<TaskId, TaskBO> getTasks(Set<TaskId> var1);

    @Nonnull
    public ImmutableMap<TaskId, TaskBO> getVisibleTasks(Set<TaskId> var1, TaskAuthorizationContext var2);

    public void reorderTasks(TaskFilterId var1, TaskId var2, TaskId var3, TaskAuthorizationContext var4);

    public void setStatus(TaskId var1, TaskStatus var2, PersonId var3, TaskAuthorizationContext var4);

    public void setName(TaskId var1, String var2, TaskAuthorizationContext var3);

    @Nonnull
    public TaskId createTask(TaskFilterId var1, @Nullable String var2, TaskAuthorizationContext var3);

    @Nonnull
    public TaskId createRecommendationTask(PersonId var1, @Nullable PersonId var2, String var3, String var4, @Nullable TaskId var5, String var6, String var7);

    public void deleteTaskAndSubtasks(TaskId var1, TaskAuthorizationContext var2);

    public void setDescription(TaskId var1, String var2, TaskAuthorizationContext var3);

    public void setDueDate(TaskId var1, @Nullable DateTime var2, TaskAuthorizationContext var3);

    @Nonnull
    public ImmutableList<TaskBO> getTasksByFilter(TaskFilterId var1, TaskStatus var2, int var3, int var4, TaskAuthorizationContext var5);

    @Nonnull
    public ImmutableMultiset<TaskStatus> getTaskCountByStatus(TaskFilterId var1, TaskAuthorizationContext var2);

    @Nonnull
    public ImmutableSet<TaskAction> getAllowedActionsForFilter(TaskFilterId var1, TaskStatus var2, TaskAuthorizationContext var3);
}

