/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tasks.authorization.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.tasks.authorization.model.TaskAuthorizationItem;
import de.justsoftware.onx.tasks.business.model.TaskBO;
import de.justsoftware.onx.tasks.shared.model.TaskId;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TaskItem
implements TaskAuthorizationItem<TaskId> {
    public static final Function<TaskBO, TaskItem> FROM_TASKBO = new NullPermeableFunction<TaskBO, TaskItem>(){

        @Override
        protected TaskItem applySafe(TaskBO input) {
            return new TaskItem(input);
        }
    };
    public static final Function<TaskItem, TaskBO> TO_TASKBO = new NullPermeableFunction<TaskItem, TaskBO>(){

        @Override
        protected TaskBO applySafe(TaskItem input) {
            return input._taskBO;
        }
    };
    private final TaskBO _taskBO;

    public TaskItem(TaskBO taskBO) {
        this._taskBO = taskBO;
    }

    @Override
    public TaskId getId() {
        return this._taskBO.getId();
    }

    @Override
    public ItemId getParentId() {
        return this._taskBO.getParentId();
    }

    @CheckForNull
    public PersonId getAssigneeId() {
        return this._taskBO.getAssigneeId();
    }

    @Nonnull
    public PersonId getOwnerId() {
        return this._taskBO.getOwnerId();
    }

    @Override
    public ComponentType getModuleType() {
        return null;
    }

    @Override
    public <T> T accept(ItemVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("taskBo", (Object)this._taskBO).toString();
    }
}

