/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tasks.authorization.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import de.justsoftware.onx.tasks.authorization.TaskListItemHandler;
import de.justsoftware.onx.tasks.authorization.model.TaskListItem;
import de.justsoftware.onx.tasks.integration.persistence.TaskDAO;
import de.justsoftware.onx.tasks.shared.model.TaskListId;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class TaskListItemHandlerImpl
implements TaskListItemHandler {
    private final TaskDAO _taskDAO;

    @Autowired
    public TaskListItemHandlerImpl(TaskDAO taskDAO) {
        this._taskDAO = taskDAO;
    }

    @Override
    public Map<TaskListId, TaskListItem> getByIds(ImmutableSet<TaskListId> ids) {
        return Maps.transformValues(this._taskDAO.getTaskListsByIds((Set<TaskListId>)ids), TaskListItem::new);
    }
}

