/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tasks.authorization.impl;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.ProfileReadRole;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.tasks.authorization.TaskAction;
import de.justsoftware.onx.tasks.authorization.TaskAuthorizationContext;
import de.justsoftware.onx.tasks.authorization.model.TaskAuthorizationItem;
import de.justsoftware.onx.tasks.shared.model.TaskAuthorizationItemId;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TaskAuthorizationContextImpl
implements TaskAuthorizationContext {
    private final AuthorizationCheckContextWithUserId _authCtx;

    public TaskAuthorizationContextImpl(AuthorizationCheckContextWithUserId authCtx) {
        this._authCtx = authCtx;
    }

    @Override
    public ImmutableSet<TaskAction> may(TaskAuthorizationItemId itemId, Set<TaskAction> actions) {
        return FluentIterable.from(this._authCtx.may((ItemId)itemId, (ImmutableSet<? extends Action>)ImmutableSet.copyOf(actions))).filter(TaskAction.class).toSet();
    }

    @Override
    public boolean may(TaskAuthorizationItemId taskId, TaskAction action) {
        return this._authCtx.may((ItemId)taskId, (Action)action);
    }

    @Override
    public PersonId getPersonId() {
        return this._authCtx.getUserId();
    }

    @Override
    public PersonId getNullablePersonId() {
        return this._authCtx.getUserId();
    }

    @Override
    public void check(TaskAuthorizationItemId taskId, TaskAction action) {
        this._authCtx.check((ItemId)taskId, (Action)action);
    }

    @Override
    public void check(TaskAuthorizationItem<?> taskItem, TaskAction action) {
        this._authCtx.check(taskItem, (Action)action);
    }

    @Override
    public void check(TaskAction action) {
        this._authCtx.check(action);
    }

    @Override
    public void checkProfileVisibility(ImmutableSet<PersonId> personIds) {
        this._authCtx.check((ImmutableCollection<ProfileReadRole>)((ImmutableCollection)personIds.stream().map(ProfileReadRole::of).collect(ImmutableSet.toImmutableSet())));
    }

    @Override
    public <T extends TaskAuthorizationItem<?>> Iterable<T> filterAllowedItems(Iterable<T> items, TaskAction action) {
        return this._authCtx.filterAllowedItems(items, action);
    }

    @Override
    public ImmutableSetMultimap<Optional<TaskAuthorizationItemId>, TaskAction> may(Iterable<? extends TaskAuthorizationItem<?>> items, ImmutableSet<TaskAction> actions) {
        return this._authCtx.may(items, actions);
    }

    @Override
    public boolean may(TaskAction action) {
        return this._authCtx.may(action);
    }
}

