/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.survey.integration.persistence.ibatis;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.survey.integration.persistence.SurveyDAO;
import de.justsoftware.onx.survey.shared.model.DBMultipleChoiceAnswer;
import de.justsoftware.onx.survey.shared.model.DBSurvey;
import de.justsoftware.onx.survey.shared.model.DBSurveyParticipantAnswer;
import de.justsoftware.onx.survey.shared.model.DBSurveyQuestion;
import de.justsoftware.onx.survey.shared.model.MultipleChoiceAnswerId;
import de.justsoftware.onx.survey.shared.model.SurveyId;
import de.justsoftware.onx.survey.shared.model.SurveyQuestionId;
import de.justsoftware.toolbox.clock.Clock;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IbatisSurveyDAO
implements SurveyDAO {
    private final IbatisStatementBuilder _ibatisBuilder;
    private final Clock _clock;

    @Autowired
    @ParametersAreNonnullByDefault
    public IbatisSurveyDAO(StatementBuilderFactory statementBuilderFactory, Clock clock) {
        this._clock = clock;
        this._ibatisBuilder = statementBuilderFactory.ibatistStatementBuilder("Survey");
    }

    @Override
    public void insertSurveyBaseData(DBSurvey survey) {
        if (survey.getCreateDate() == null) {
            survey.setCreateDate(this._clock.nowDate());
        }
        this._ibatisBuilder.insert("insertSurveyBaseData").param(survey);
    }

    @Override
    public void updateSurveyBaseData(DBSurvey survey) {
        this._ibatisBuilder.update("updateSurveyBaseData").param(survey);
    }

    @Override
    public void deleteSurveysByIds(Iterable<SurveyId> ids) {
        this._ibatisBuilder.delete("deleteSurveysByIds").partition(ImmutableSet.copyOf(ids));
    }

    @Override
    public DBSurvey getSurveyById(SurveyId id) {
        return (DBSurvey)this._ibatisBuilder.select("getSurveyById").param(id).asObject();
    }

    @Override
    public List<DBSurvey> getSurveysByParentId(GlobalId id) {
        return this._ibatisBuilder.select("getSurveysByParentId").param(id.asMap()).asList();
    }

    @Override
    public void insertMultipleChoiceAnswer(DBMultipleChoiceAnswer answer) {
        this._ibatisBuilder.insert("insertMultipleChoiceAnswer").param(answer);
    }

    @Override
    public void updateMultipleChoiceAnswer(DBMultipleChoiceAnswer answer) {
        this._ibatisBuilder.update("updateMultipleChoiceAnswer").param(answer);
    }

    @Override
    public void deleteMultipleChoiceAnswer(MultipleChoiceAnswerId id) {
        this._ibatisBuilder.delete("deleteMultipleChoiceAnswer").param(id);
    }

    @Override
    public void insertQuestionBaseData(DBSurveyQuestion surveyQuestion) {
        this._ibatisBuilder.insert("insertQuestionBaseData").param(surveyQuestion);
    }

    @Override
    public void updateQuestionBaseData(DBSurveyQuestion surveyQuestion) {
        this._ibatisBuilder.update("updateQuestionBaseData").param(surveyQuestion);
    }

    @Override
    public void deleteQuestion(SurveyQuestionId id) {
        this._ibatisBuilder.delete("deleteQuestion").param(id);
    }

    @Override
    public void deleteQuestionsBySurveyId(SurveyId surveyId) {
        this._ibatisBuilder.delete("deleteQuestionsBySurveyId").param(surveyId);
    }

    @Override
    public void insertMultipleChoiceAnswers(List<DBMultipleChoiceAnswer> answers) {
        this._ibatisBuilder.insert("insertMultipleChoiceAnswers").partition(ImmutableSet.copyOf(answers));
    }

    @Override
    public void deleteParticipantAnswersByPersonIdAndSurveyId(PersonId personId, SurveyId surveyId) {
        this._ibatisBuilder.delete("deleteParticipantAnswersByPersonIdAndSurveyId").param("personId", personId, "surveyId", surveyId);
    }

    @Override
    public ImmutableList<DBSurveyParticipantAnswer> getParticipantAnswersByPersonIdAndSurveyId(PersonId personId, SurveyId surveyId) {
        return ((IbatisStandardResultBuilder)this._ibatisBuilder.select("getParticipantAnswersByPersonIdAndSurveyId").param("personId", personId, "surveyId", surveyId)).asList();
    }

    @Override
    public void insertParticipantAnswers(List<DBSurveyParticipantAnswer> participantAnswers) {
        this._ibatisBuilder.insert("insertParticipantAnswers").partition(ImmutableSet.copyOf(participantAnswers));
    }

    @Override
    public ImmutableList<DBSurveyParticipantAnswer> getParticipantAnswersBySurveyId(SurveyId surveyId) {
        return this._ibatisBuilder.select("getParticipantAnswersBySurveyId").param(surveyId).asList();
    }

    @Override
    public int getParticipantCount(SurveyId surveyId) {
        return this._ibatisBuilder.select("getParticipantCount").param(surveyId).asCount();
    }

    @Override
    public void deleteParticipantAnswersByPersonIdAndSurveyIds(PersonId personId, Iterable<SurveyId> surveyIds) {
        this._ibatisBuilder.delete("deleteParticipantAnswersByPersonIdAndSurveyIds").partition("surveyIds", ImmutableSet.copyOf(surveyIds), (Map<String, ?>)ImmutableMap.of((Object)"personId", (Object)personId));
    }

    @Override
    public ImmutableList<SurveyId> getParticipatedSurveyIdsByPersonId(PersonId personId) {
        return this._ibatisBuilder.select("getParticipatedSurveyIdsByPersonId").param(personId).asList();
    }

    @Override
    public ImmutableList<DBSurvey> getSurveysByIds(Iterable<SurveyId> surveyIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisBuilder.select("getSurveysByIds").partition(ImmutableSet.copyOf(surveyIds))).asList();
    }

    @Override
    public ImmutableSet<SurveyId> getSurveyIdsByParentId(GlobalId parentId) {
        return this._ibatisBuilder.select("getSurveyIdsByParentId").param(parentId.asMap()).asSet();
    }

    @Override
    public SurveyId getRedirectSurveyOnNewMembership(EntityId entityId) {
        return (SurveyId)this._ibatisBuilder.selectDbSpecific("getRedirectSurveyOnNewMembership").param(entityId.asMap()).asObject();
    }
}

