/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.survey.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.survey.business.SurveyPublishedStreamHandler;
import de.justsoftware.onx.survey.business.SurveyService;
import de.justsoftware.onx.survey.shared.model.DBSurvey;
import de.justsoftware.onx.survey.shared.model.SurveyId;
import de.justsoftware.onx.workstream.business.AbstractSingleWorkstreamMessageHandler;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.SurveyPublished;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="surveyPublishedStreamHandler")
public class SurveyPublishedStreamHandlerImpl
extends AbstractSingleWorkstreamMessageHandler<SurveyPublished>
implements SurveyPublishedStreamHandler {
    @Autowired
    private SurveyService _surveyService;

    @Override
    public ImmutableSetMultimap<String, String> attributesToDelete(Set<? extends ItemId> itemIds) {
        return SurveyPublishedStreamHandlerImpl.attributesToDelete(itemIds, "survey_id", SurveyId.class);
    }

    @Override
    protected SurveyPublished convert(DBWorkstreamMessage m, PersonTeaserModel authorTeaser, ImmutableSet<Action> may, AuthorizationCheckContextWithLocale authorizationContext) {
        SurveyId surveyId = SurveyId.parse(m.getAttribute("survey_id"));
        if (surveyId == null) {
            return null;
        }
        DBSurvey survey = this._surveyService.getBySurveyId(surveyId);
        if (survey == null) {
            return null;
        }
        return new SurveyPublished(m, authorTeaser, may, survey.getTitle());
    }
}

