/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.survey.business.impl;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.ServerLocalizedMessages;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.business.csvexport.EntityDataExportService;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.export.csv.server.i18n.CsvExportConstants;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.business.attributes.errors.ConfigErrorException;
import de.justsoftware.onx.person.business.attributes.i18n.Language;
import de.justsoftware.onx.person.business.attributes.i18n.Translations;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.i18n.ProfileConstants;
import de.justsoftware.onx.survey.business.SurveyExportService;
import de.justsoftware.onx.survey.business.SurveyService;
import de.justsoftware.onx.survey.shared.model.DBMultipleChoiceAnswer;
import de.justsoftware.onx.survey.shared.model.DBSurvey;
import de.justsoftware.onx.survey.shared.model.DBSurveyParticipantAnswer;
import de.justsoftware.onx.survey.shared.model.DBSurveyQuestion;
import de.justsoftware.onx.survey.shared.model.MultipleChoiceAnswerId;
import de.justsoftware.onx.survey.shared.model.SurveyDetails;
import de.justsoftware.onx.survey.shared.model.SurveyId;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.FmtDate;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.constraint.NotNull;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.CsvContext;

@Service
@ParametersAreNonnullByDefault
public class SurveyExportServiceImpl
implements SurveyExportService {
    private static final CellProcessor NOT_NULL = new NotNull();
    private static final CellProcessor OPTIONAL = new Optional();
    private static final CellProcessor DATE = new FmtDate("yyyy-MM-dd HH:mm");
    private static final ImmutableMap<EntityDataExportService.ExportColumnKeys, CellProcessor> CSV_COLUMNS = ImmutableMap.builder().put((Object)EntityDataExportService.ExportColumnKeys.SURVEY_PARTICIPANT_NUMBER, (Object)OPTIONAL).put((Object)EntityDataExportService.ExportColumnKeys.PERSON_ID, (Object)OPTIONAL).put((Object)EntityDataExportService.ExportColumnKeys.PERSON_TITLE, (Object)OPTIONAL).put((Object)EntityDataExportService.ExportColumnKeys.PERSON_FIRST_NAME, (Object)OPTIONAL).put((Object)EntityDataExportService.ExportColumnKeys.PERSON_LAST_NAME, (Object)OPTIONAL).put((Object)EntityDataExportService.ExportColumnKeys.PERSON_ADDITIONAL_TITLE, (Object)OPTIONAL).put((Object)EntityDataExportService.ExportColumnKeys.SURVEY_PARTICIPANT_DATE, (Object)DATE).build();
    private static final ImmutableMap<EntityDataExportService.ExportColumnKeys, CellProcessor> ANONYMOUS_CSV_COLUMNS = ImmutableMap.builder().put((Object)EntityDataExportService.ExportColumnKeys.SURVEY_PARTICIPANT_NUMBER, (Object)OPTIONAL).put((Object)EntityDataExportService.ExportColumnKeys.SURVEY_PARTICIPANT_DATE, (Object)DATE).build();
    private static final Logger LOG = LoggerFactory.getLogger(SurveyExportServiceImpl.class);
    private final SurveyService _surveyService;
    private final PersonService _personService;
    private final I18nService _i18nService;

    @Autowired
    public SurveyExportServiceImpl(SurveyService surveyService, PersonService personService, I18nService i18nService) {
        this._surveyService = surveyService;
        this._personService = personService;
        this._i18nService = i18nService;
    }

    @Override
    public String createSurveyResultCSV(SurveyId surveyId, AuthorizationCheckContextWithUserId authCtx) throws IOException {
        authCtx.check((ItemId)surveyId, (Action)StaticAction.SURVEY_READ_RESULT);
        SurveyDetails surveyDetails = this._surveyService.getSurveyDetailsById(surveyId, authCtx);
        ImmutableList<NamedCellProcessor> csvDefinition = this.createCsvColums(surveyDetails.getSurveyData(), authCtx);
        String[] header = (String[])FluentIterable.from(csvDefinition).transform(NamedCellProcessor.TO_NAME).filter(Predicates.notNull()).toArray(String.class);
        CellProcessor[] processors = (CellProcessor[])FluentIterable.from(csvDefinition).transform(NamedCellProcessor.TO_PROCESSOR).filter(Predicates.notNull()).toArray(CellProcessor.class);
        StringWriter resultWriter = new StringWriter();
        resultWriter.write("\ufeff");
        CsvListWriter csvWriter = new CsvListWriter((Writer)resultWriter, CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE);
        csvWriter.writeHeader(header);
        ImmutableList<DBSurveyParticipantAnswer> answers = this._surveyService.getParticipantAnswersBySurveyId(surveyId, authCtx);
        if (!answers.isEmpty()) {
            ImmutableList<ImmutableList<Object>> answerRows = this.transformAnswers(surveyDetails, answers);
            for (ImmutableList row : answerRows) {
                csvWriter.write((List)row, processors);
            }
        }
        csvWriter.flush();
        csvWriter.close();
        return resultWriter.toString().trim();
    }

    @Nonnull
    private ImmutableMap<EntityDataExportService.ExportColumnKeys, String> getCsvHeaderTranslations(CsvExportConstants csvExportConstants, ProfileConstants profileConstants, EntityConstants entityConstants, String locale) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        try {
            Language language = Language.of(locale);
            EntityDataExportService.CSVHeaderTranslator translator = new EntityDataExportService.CSVHeaderTranslator(new Translations(language, csvExportConstants.overriddenSurveyExportHeader()), new Translations(language, EntityDataExportService.ExportColmnKeysTranslator.translateAll(language, csvExportConstants, profileConstants, entityConstants)));
            for (EntityDataExportService.ExportColumnKeys key : Sets.union((Set)CSV_COLUMNS.keySet(), (Set)ANONYMOUS_CSV_COLUMNS.keySet())) {
                builder.put((Object)key, (Object)((String)MoreObjects.firstNonNull((Object)((String)translator.apply(key.name())), (Object)key.name())));
            }
        }
        catch (ConfigErrorException e) {
            LOG.error(e.getMessage());
        }
        return builder.build();
    }

    @Nonnull
    private ImmutableList<NamedCellProcessor> createCsvColums(DBSurvey survey, AuthorizationCheckContextWithUserId authCtx) {
        String locale = authCtx.getLocale();
        ServerLocalizedMessages messages = this._i18nService.getLocalizedMessages(locale);
        CsvExportConstants csvExportConstants = messages.csvExportConstants();
        YesNoCellProcessor yesNoCellProcessor = new YesNoCellProcessor(csvExportConstants);
        ImmutableMap<EntityDataExportService.ExportColumnKeys, String> translationMap = this.getCsvHeaderTranslations(csvExportConstants, messages.profileConstants(), messages.entityConstants(EntityType.NETWORK), locale);
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableMap<EntityDataExportService.ExportColumnKeys, CellProcessor> fixedColumns = survey.isAnonym() ? ANONYMOUS_CSV_COLUMNS : CSV_COLUMNS;
        for (Map.Entry entry : fixedColumns.entrySet()) {
            String translatedKey = (String)MoreObjects.firstNonNull((Object)((String)translationMap.get(entry.getKey())), (Object)((EntityDataExportService.ExportColumnKeys)((Object)entry.getKey())).name());
            builder.add((Object)NamedCellProcessor.of(translatedKey, (CellProcessor)entry.getValue()));
        }
        for (DBSurveyQuestion question : survey.getQuestions()) {
            CellProcessor processor;
            CellProcessor cellProcessor = processor = question.isOptional() ? OPTIONAL : NOT_NULL;
            if (question.isFreetextAnswer()) {
                builder.add((Object)NamedCellProcessor.of(question.getQuestion(), processor));
                continue;
            }
            if (Integer.valueOf(1).equals(question.getMaxAnswers())) {
                builder.add((Object)NamedCellProcessor.of(question.getQuestion(), processor));
                continue;
            }
            for (DBMultipleChoiceAnswer answer : question.getMultipleChoiceAnswers()) {
                builder.add((Object)NamedCellProcessor.of(question.getQuestion() + ": " + answer.getAnswer(), (CellProcessor)yesNoCellProcessor));
            }
        }
        return builder.build();
    }

    @Nonnull
    private ImmutableList<ImmutableList<Object>> transformAnswers(SurveyDetails details, ImmutableList<DBSurveyParticipantAnswer> answers) {
        ImmutableListMultimap answersByParticipant = Multimaps.index(answers, DBSurveyParticipantAnswer.TO_PARTICIPANT_ID);
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        boolean isAnonym = details.getSurveyData().isAnonym();
        ImmutableMap<PersonId, DBPerson> persons = isAnonym ? ImmutableMap.of() : this._personService.getPersonsByIds((Set<PersonId>)answersByParticipant.keySet());
        int count = 0;
        for (Map.Entry data : answersByParticipant.asMap().entrySet()) {
            PersonId personId = (PersonId)data.getKey();
            ImmutableList.Builder rowBuilder = ImmutableList.builder();
            rowBuilder.add((Object)(++count));
            if (!isAnonym) {
                rowBuilder.add((Object)personId);
                this.addPersonDataColumns((ImmutableList.Builder<Object>)rowBuilder, (DBPerson)persons.get((Object)personId));
            }
            Iterable currentAnswers = (Iterable)data.getValue();
            this.addAnswerDate((ImmutableList.Builder<Object>)rowBuilder, currentAnswers);
            this.addQuestionColumns((ImmutableList.Builder<Object>)rowBuilder, details, currentAnswers);
            rowsBuilder.add((Object)rowBuilder.build());
        }
        return rowsBuilder.build();
    }

    private void addAnswerDate(ImmutableList.Builder<Object> rowBuilder, @Nullable Iterable<DBSurveyParticipantAnswer> currentAnswers) {
        if (!CollectionUtil.isEmpty(currentAnswers)) {
            rowBuilder.add(FluentIterable.from(currentAnswers).transform(DBSurveyParticipantAnswer.TO_MODIFY_DATE).toSortedSet((Comparator)Ordering.natural().reverse()).first());
        } else {
            this.skipColumnValue(rowBuilder);
        }
    }

    private void addPersonDataColumns(ImmutableList.Builder<Object> rowBuilder, @Nullable DBPerson person) {
        if (person != null) {
            this.addColumnValue(rowBuilder, person.getTitle());
            this.addColumnValue(rowBuilder, person.getFirstName());
            this.addColumnValue(rowBuilder, person.getLastName());
            this.addColumnValue(rowBuilder, person.getAdditionalTitle());
        } else {
            this.skipColumnValue(rowBuilder);
            this.skipColumnValue(rowBuilder);
            this.skipColumnValue(rowBuilder);
            this.skipColumnValue(rowBuilder);
        }
    }

    private void skipColumnValue(ImmutableList.Builder<Object> rowBuilder) {
        this.addColumnValue(rowBuilder, null);
    }

    private void addColumnValue(ImmutableList.Builder<Object> rowBuilder, @Nullable String value) {
        if (StringUtil.isBlank(value)) {
            rowBuilder.add((Object)"");
        } else {
            rowBuilder.add((Object)value);
        }
    }

    private void addQuestionColumns(ImmutableList.Builder<Object> rowBuilder, SurveyDetails details, Iterable<DBSurveyParticipantAnswer> currentAnswers) {
        ImmutableListMultimap answersByQuestion = Multimaps.index(currentAnswers, DBSurveyParticipantAnswer.TO_SURVEY_QUESTION_ID);
        for (DBSurveyQuestion question : details.getSurveyData().getQuestions()) {
            if (question.isFreetextAnswer()) {
                ImmutableList freetextAnswers = answersByQuestion.get((Object)question.getId());
                if (!freetextAnswers.isEmpty()) {
                    rowBuilder.add((Object)((DBSurveyParticipantAnswer)Iterables.getOnlyElement((Iterable)freetextAnswers)).getFreetextAnswer());
                    continue;
                }
                rowBuilder.add((Object)"");
                continue;
            }
            if (Integer.valueOf(1).equals(question.getMaxAnswers())) {
                ImmutableList answers = answersByQuestion.get((Object)question.getId());
                if (!answers.isEmpty()) {
                    MultipleChoiceAnswerId answerId = ((DBSurveyParticipantAnswer)Iterables.getOnlyElement((Iterable)answers)).getMultipleChoiceAnswerId();
                    ImmutableMap answerMap = Maps.uniqueIndex(question.getMultipleChoiceAnswers(), Identifiables.toId());
                    rowBuilder.add((Object)((DBMultipleChoiceAnswer)answerMap.get((Object)answerId)).getAnswer());
                    continue;
                }
                rowBuilder.add((Object)"");
                continue;
            }
            ImmutableMap multiAnswers = Maps.uniqueIndex((Iterable)answersByQuestion.get((Object)question.getId()), DBSurveyParticipantAnswer.TO_MULTIPLE_CHOICE_ANDWER_ID);
            for (DBMultipleChoiceAnswer answer : question.getMultipleChoiceAnswers()) {
                DBSurveyParticipantAnswer currentAnswer = (DBSurveyParticipantAnswer)multiAnswers.get((Object)answer.getId());
                rowBuilder.add((Object)(currentAnswer != null ? 1 : 0));
            }
        }
    }

    @ParametersAreNonnullByDefault
    private static final class YesNoCellProcessor
    extends CellProcessorAdaptor {
        private final String _yes;
        private final String _no;

        public YesNoCellProcessor(CsvExportConstants csvExportConstants) {
            this._yes = csvExportConstants.surveyAnswerYes();
            this._no = csvExportConstants.surveyAnswerNo();
        }

        public Object execute(Object value, CsvContext context) {
            boolean answerIsYes = value != null && Boolean.parseBoolean(value.toString());
            return answerIsYes ? this._yes : this._no;
        }
    }

    @ParametersAreNonnullByDefault
    private static final class NamedCellProcessor {
        public static final Function<NamedCellProcessor, String> TO_NAME = new NullPermeableFunction<NamedCellProcessor, String>(){

            @Override
            protected String applySafe(NamedCellProcessor input) {
                return input.getName();
            }
        };
        public static final Function<NamedCellProcessor, CellProcessor> TO_PROCESSOR = new NullPermeableFunction<NamedCellProcessor, CellProcessor>(){

            @Override
            protected CellProcessor applySafe(NamedCellProcessor input) {
                return input.getProcessor();
            }
        };
        private final String _name;
        private final CellProcessor _processor;

        private NamedCellProcessor(String name, CellProcessor processor) {
            this._name = name;
            this._processor = processor;
        }

        @Nonnull
        public String getName() {
            return this._name;
        }

        @Nonnull
        public CellProcessor getProcessor() {
            return this._processor;
        }

        @Nonnull
        public static NamedCellProcessor of(String name, CellProcessor processor) {
            return new NamedCellProcessor(name, processor);
        }
    }
}

