/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.survey.business;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.EntityModuleHandler;
import de.justsoftware.onx.container.business.ProfileModuleHandler;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.survey.shared.model.DBSurvey;
import de.justsoftware.onx.survey.shared.model.DBSurveyParticipantAnswer;
import de.justsoftware.onx.survey.shared.model.DBSurveyQuestion;
import de.justsoftware.onx.survey.shared.model.QuestionSaveResult;
import de.justsoftware.onx.survey.shared.model.SurveyDetails;
import de.justsoftware.onx.survey.shared.model.SurveyId;
import de.justsoftware.onx.survey.shared.model.SurveyResult;
import de.justsoftware.onx.survey.shared.model.SurveyTeaser;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public interface SurveyService
extends EntityModuleHandler,
ProfileModuleHandler {
    public static final int MAX_SURVEYS_PER_REQUEST = 100;

    public boolean hasParticipateSurvey(PersonId var1, SurveyId var2);

    @CheckForNull
    public DBSurvey getBySurveyId(SurveyId var1);

    public boolean isExpired(DBSurvey var1);

    public Map<SurveyId, DBSurvey> getSurveysByIds(Collection<SurveyId> var1);

    public void deleteSurveyParticipantAnswers(@Nonnull SurveyId var1, @Nonnull AuthorizationCheckContextWithUserId var2);

    public void saveSurveyParticipantAnswers(@Nonnull SurveyId var1, @Nonnull List<DBSurveyParticipantAnswer> var2, @Nonnull AuthorizationCheckContextWithUserId var3);

    public void deleteSurvey(@Nonnull SurveyId var1, @Nonnull AuthorizationCheckContextWithUserId var2);

    public void deleteDependentSurveys(@Nonnull Iterable<SurveyId> var1, @Nonnull GlobalId var2, @Nonnull DeletionContext var3);

    public SurveyResult getSurveyResultById(SurveyId var1);

    public SurveyId insertSurveyBaseData(PersonId var1, DBSurvey var2);

    public void updateSurveyBaseData(DBSurvey var1);

    @Nonnull
    public QuestionSaveResult saveQuestions(@Nonnull SurveyId var1, @Nonnull List<DBSurveyQuestion> var2, boolean var3, @Nonnull AuthorizationCheckContextWithUserId var4);

    @Nonnull
    public ListAndCount<SurveyTeaser> getSurveyTeasersByParentId(@Nonnull GlobalId var1, int var2, int var3, @Nonnull AuthorizationCheckContextWithUserId var4);

    @Nonnull
    public SurveyTeaser getSurveyTeaser(@Nonnull DBSurvey var1, @Nonnull AuthorizationCheckContextWithUserId var2);

    public SurveyDetails getSurveyDetailsById(SurveyId var1, @Nonnull AuthorizationCheckContextWithUserId var2);

    @Nonnull
    public ImmutableSet<SurveyId> getSurveyIdsByParentId(@Nonnull GlobalId var1);

    @Nonnull
    public ImmutableList<DBSurveyParticipantAnswer> getParticipantAnswersBySurveyId(@Nonnull SurveyId var1, @Nonnull AuthorizationCheckContextWithUserId var2);

    @CheckForNull
    public SurveyId getRedirectSurveyOnNewMembership(@Nonnull EntityId var1, @Nonnull AuthorizationCheckContextWithUserId var2);
}

