/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.social;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SocialClientVersion {
    public static final SocialClientVersion UNKNOWN_PLATFORM_VERSION = new SocialClientVersion(Platform.UNKNOWN, 0L);
    private final Platform _platform;
    private final long _versionCode;

    public SocialClientVersion(Platform platform, long versionCode) {
        this._platform = platform;
        this._versionCode = versionCode;
    }

    @Nonnull
    public Platform getPlatform() {
        return this._platform;
    }

    public long getVersionCode() {
        return this._versionCode;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("platform", (Object)this._platform).add("versionCode", this._versionCode).toString();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof SocialClientVersion && Arrays.equals(this.getHashObjects(), ((SocialClientVersion)obj).getHashObjects());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getHashObjects());
    }

    @Nonnull
    private Object[] getHashObjects() {
        return new Object[]{this._platform, this._versionCode};
    }

    @ParametersAreNonnullByDefault
    public static enum Platform {
        ANDROID("Android"),
        IOS("iOS"),
        UNKNOWN("Unknown");

        private final String _displayName;

        private Platform(String displayName) {
            this._displayName = displayName;
        }

        @Nonnull
        public String displayName() {
            return this._displayName;
        }
    }
}

