/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Stack;

public class ComparableVersion
implements Comparable<ComparableVersion> {
    private String _value;
    private String _canonical;
    private ListItem _items;

    public ComparableVersion(String version) {
        this.parseVersion(version);
    }

    public final void parseVersion(String version) {
        this._value = version;
        this._items = new ListItem();
        String versionLowercase = version.toLowerCase(Locale.ENGLISH);
        ListItem list = this._items;
        Stack<ListItem> stack = new Stack<ListItem>();
        stack.push(list);
        boolean isDigit = false;
        int startIndex = 0;
        for (int i = 0; i < versionLowercase.length(); ++i) {
            char c = versionLowercase.charAt(i);
            if (c == '.') {
                if (i == startIndex) {
                    list.add(IntegerItem.ZERO);
                } else {
                    list.add(ComparableVersion.parseItem(isDigit, versionLowercase.substring(startIndex, i)));
                }
                startIndex = i + 1;
                continue;
            }
            if (c == '-') {
                if (i == startIndex) {
                    list.add(IntegerItem.ZERO);
                } else {
                    list.add(ComparableVersion.parseItem(isDigit, versionLowercase.substring(startIndex, i)));
                }
                startIndex = i + 1;
                ListItem listItem = list;
                list = new ListItem();
                listItem.add(list);
                stack.push(list);
                continue;
            }
            if (Character.isDigit(c)) {
                if (!isDigit && i > startIndex) {
                    list.add(new StringItem(versionLowercase.substring(startIndex, i), true));
                    startIndex = i;
                    ListItem listItem = list;
                    list = new ListItem();
                    listItem.add(list);
                    stack.push(list);
                }
                isDigit = true;
                continue;
            }
            if (isDigit && i > startIndex) {
                list.add(ComparableVersion.parseItem(true, versionLowercase.substring(startIndex, i)));
                startIndex = i;
                ListItem listItem = list;
                list = new ListItem();
                listItem.add(list);
                stack.push(list);
            }
            isDigit = false;
        }
        if (version.length() > startIndex) {
            list.add(ComparableVersion.parseItem(isDigit, version.substring(startIndex)));
        }
        while (!stack.isEmpty()) {
            list = (ListItem)stack.pop();
            list.normalize();
        }
        this._canonical = this._items.toString();
    }

    private static Item parseItem(boolean isDigit, String buf) {
        return isDigit ? new IntegerItem(buf) : new StringItem(buf, false);
    }

    @Override
    public int compareTo(ComparableVersion o) {
        return this._items.compareTo(o._items);
    }

    public String toString() {
        return this._value;
    }

    public String getCanonical() {
        return this._canonical;
    }

    public boolean equals(Object o) {
        return o instanceof ComparableVersion && this._canonical.equals(((ComparableVersion)o)._canonical);
    }

    public int hashCode() {
        return this._canonical.hashCode();
    }

    private static class ListItem
    extends ArrayList<Item>
    implements Item {
        private static final long serialVersionUID = 1L;

        private ListItem() {
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public boolean isNull() {
            return this.size() == 0;
        }

        void normalize() {
            for (int i = this.size() - 1; i >= 0; --i) {
                Item lastItem = (Item)this.get(i);
                if (lastItem.isNull()) {
                    this.remove(i);
                    continue;
                }
                if (!(lastItem instanceof ListItem)) break;
            }
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                if (this.size() == 0) {
                    return 0;
                }
                Item first = (Item)this.get(0);
                return first.compareTo(null);
            }
            switch (item.getType()) {
                case 0: {
                    return -1;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    Iterator left = this.iterator();
                    Iterator right = ((ListItem)item).iterator();
                    while (left.hasNext() || right.hasNext()) {
                        Item r;
                        Item l = left.hasNext() ? (Item)left.next() : null;
                        Item item2 = r = right.hasNext() ? (Item)right.next() : null;
                        int result = l == null ? (r == null ? 0 : -1 * r.compareTo(null)) : l.compareTo(r);
                        if (result == 0) continue;
                        return result;
                    }
                    return 0;
                }
            }
            throw new IllegalArgumentException("invalid item: " + item.getClass());
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder();
            for (Item item : this) {
                if (buffer.length() > 0) {
                    buffer.append(item instanceof ListItem ? (char)'-' : '.');
                }
                buffer.append(item);
            }
            return buffer.toString();
        }
    }

    private static class StringItem
    implements Item {
        private static final String[] QUALIFIERS = new String[]{"alpha", "beta", "milestone", "rc", "snapshot", "", "sp"};
        private static final List<String> QUALIFIERS_LIST = Arrays.asList(QUALIFIERS);
        private static final Properties ALIASES = new Properties();
        private static final String RELEASE_VERSION_INDEX;
        private final String _stringValue;

        public StringItem(String value, boolean followedByDigit) {
            String stringValue = value;
            if (followedByDigit && value.length() == 1) {
                switch (value.charAt(0)) {
                    case 'a': {
                        stringValue = "alpha";
                        break;
                    }
                    case 'b': {
                        stringValue = "beta";
                        break;
                    }
                    case 'm': {
                        stringValue = "milestone";
                        break;
                    }
                    default: {
                        stringValue = value;
                    }
                }
            }
            this._stringValue = ALIASES.getProperty(stringValue, value);
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public boolean isNull() {
            return StringItem.comparableQualifier(this._stringValue).compareTo(RELEASE_VERSION_INDEX) == 0;
        }

        public static String comparableQualifier(String qualifier) {
            int i = QUALIFIERS_LIST.indexOf(qualifier);
            return i == -1 ? QUALIFIERS_LIST.size() + "-" + qualifier : String.valueOf(i);
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                return StringItem.comparableQualifier(this._stringValue).compareTo(RELEASE_VERSION_INDEX);
            }
            switch (item.getType()) {
                case 0: {
                    return -1;
                }
                case 1: {
                    return StringItem.comparableQualifier(this._stringValue).compareTo(StringItem.comparableQualifier(((StringItem)item)._stringValue));
                }
                case 2: {
                    return -1;
                }
            }
            throw new IllegalArgumentException("invalid item: " + item.getClass());
        }

        public String toString() {
            return this._stringValue;
        }

        static {
            ALIASES.put("ga", "");
            ALIASES.put("final", "");
            ALIASES.put("cr", "rc");
            RELEASE_VERSION_INDEX = String.valueOf(QUALIFIERS_LIST.indexOf(""));
        }
    }

    private static class IntegerItem
    implements Item {
        private static final BigInteger BIG_INTEGER_ZERO = new BigInteger("0");
        private static final IntegerItem ZERO = new IntegerItem();
        private final BigInteger _value;

        private IntegerItem() {
            this._value = BIG_INTEGER_ZERO;
        }

        public IntegerItem(String str) {
            this._value = new BigInteger(str);
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public boolean isNull() {
            return BIG_INTEGER_ZERO.equals(this._value);
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                return BIG_INTEGER_ZERO.equals(this._value) ? 0 : 1;
            }
            switch (item.getType()) {
                case 0: {
                    return this._value.compareTo(((IntegerItem)item)._value);
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 1;
                }
            }
            throw new IllegalArgumentException("invalid item: " + item.getClass());
        }

        public String toString() {
            return this._value.toString();
        }
    }

    private static interface Item {
        public static final int INTEGER_ITEM = 0;
        public static final int STRING_ITEM = 1;
        public static final int LIST_ITEM = 2;

        public int compareTo(Item var1);

        public int getType();

        public boolean isNull();
    }
}

