/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server.business.impl;

import de.justsoftware.onx.server.business.JucoServerVersionUpdateProcessor;
import de.justsoftware.onx.server.business.UpdateBehaviour;
import de.justsoftware.onx.server.model.JucoVersionUpdateProcess;
import de.justsoftware.onx.wiki.business.WikiInternalApiConnector;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ReindexSolrWikiVersionUpdateProcessor
implements JucoServerVersionUpdateProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ReindexSolrWikiVersionUpdateProcessor.class);
    private final WikiInternalApiConnector _wikiInternalApiConnector;

    @Autowired
    public ReindexSolrWikiVersionUpdateProcessor(WikiInternalApiConnector wikiInternalApiConnector) {
        this._wikiInternalApiConnector = wikiInternalApiConnector;
    }

    @Override
    public int getProcessorVersion() {
        return 0;
    }

    @Override
    public JucoVersionUpdateProcess getProcessType() {
        return JucoVersionUpdateProcess.REINDEX_SOLR_WIKI;
    }

    @Override
    public UpdateBehaviour getUpdateBehaviour() {
        return UpdateBehaviour.onceOnMasterForVersion(this, "12.1");
    }

    @Override
    public boolean preconditionsMet() {
        if (!this._wikiInternalApiConnector.available()) {
            LOG.warn("Reindexing solr not possible. Wiki Service is not ready. We will retry it later.");
            return false;
        }
        return true;
    }

    @Override
    public void process() {
        this._wikiInternalApiConnector.reindexWiki();
    }
}

