/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server.business.impl;

import de.justsoftware.onx.message.search.business.ChatSearchService;
import de.justsoftware.onx.server.business.JucoServerVersionUpdateProcessor;
import de.justsoftware.onx.server.business.UpdateBehaviour;
import de.justsoftware.onx.server.model.JucoVersionUpdateProcess;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.solr.client.solrj.SolrClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ReindexSolrChatJucoServerVersionUpdateProcessor
implements JucoServerVersionUpdateProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ReindexSolrChatJucoServerVersionUpdateProcessor.class);
    private final SolrClient _writeChatSolrServer;
    private final ChatSearchService _chatSearchService;

    @Autowired
    public ReindexSolrChatJucoServerVersionUpdateProcessor(@Qualifier(value="writeChatSolrServer") SolrClient writeChatSolrServer, ChatSearchService chatSearchService) {
        this._writeChatSolrServer = writeChatSolrServer;
        this._chatSearchService = chatSearchService;
    }

    @Override
    public int getProcessorVersion() {
        return 2;
    }

    @Override
    public JucoVersionUpdateProcess getProcessType() {
        return JucoVersionUpdateProcess.REINDEX_SOLR_CHAT;
    }

    @Override
    public UpdateBehaviour getUpdateBehaviour() {
        return UpdateBehaviour.onceOnMasterForVersion(this, "11.11");
    }

    @Override
    public boolean preconditionsMet() {
        try {
            this._writeChatSolrServer.ping();
        }
        catch (Exception e) {
            LOG.warn("Reindexing solr for chat not possible. Solr server is not ready ({}). We will retry it later.", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void process() {
        this._chatSearchService.fullImport(true);
    }
}

