/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server.business.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import de.justsoftware.onx.appswitcher.business.AppConfigService;
import de.justsoftware.onx.appswitcher.model.AppConfig;
import de.justsoftware.onx.appswitcher.model.AppConfigsBuilder;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.common.business.configfile.model.InitialVisibility;
import de.justsoftware.onx.server.business.JucoServerVersionService;
import de.justsoftware.onx.server.business.JucoServerVersionUpdateProcessor;
import de.justsoftware.onx.server.business.UpdateBehaviour;
import de.justsoftware.onx.server.model.JucoVersionUpdateProcess;
import de.justsoftware.permission.client.model.Role;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
@Lazy(value=false)
public class ActivateAdminAppForOldCustomerVersionUpdateProcessor
implements JucoServerVersionUpdateProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ActivateAdminAppForOldCustomerVersionUpdateProcessor.class);
    private final JucoServerVersionService _jucoServerVersionService;
    private final AppConfigService _appConfigService;

    @Autowired
    public ActivateAdminAppForOldCustomerVersionUpdateProcessor(AppConfigService appConfigService, JucoServerVersionService jucoServerVersionService) {
        this._appConfigService = appConfigService;
        this._jucoServerVersionService = jucoServerVersionService;
    }

    @Override
    public JucoVersionUpdateProcess getProcessType() {
        return JucoVersionUpdateProcess.ACTIVATE_ADMIN_APP;
    }

    @Override
    public UpdateBehaviour getUpdateBehaviour() {
        return UpdateBehaviour.onceOnMasterForVersion(this, "12.3.0");
    }

    @Override
    public boolean preconditionsMet() {
        return this._jucoServerVersionService.isUpdateProcessCompleted(JucoVersionUpdateProcess.ACTIVATE_NEW_WIKI);
    }

    @Override
    public void process() {
        boolean isNewCustomer;
        boolean bl = isNewCustomer = !this._jucoServerVersionService.hasPreviousVersionBelow("12.3.0");
        if (isNewCustomer) {
            return;
        }
        LOG.info("Activate admin app for old customer.");
        AppConfig adminAppConfig = new AppConfig(CoreApp.ADMIN.getAppId(), "Admin", null, null, null, null, null);
        ImmutableList<AppConfig> newAppConfigs = AppConfigsBuilder.from(this._appConfigService.getAllAppConfigs()).addAfterLastCoreApp(adminAppConfig).toList();
        this._appConfigService.setAllAppConfigs(newAppConfigs);
        Role tenantManager = Role.staticRole((String)"TENANT_MANAGER");
        ImmutableTable<Role, AppId, InitialVisibility> currentAppVisibilities = this._appConfigService.getInitialAppVisibilityConfigsByTenant(null);
        HashMap<AppId, InitialVisibility> appVisibilitiesForTenantManager = new HashMap<AppId, InitialVisibility>((Map<AppId, InitialVisibility>)currentAppVisibilities.row((Object)tenantManager));
        appVisibilitiesForTenantManager.put(adminAppConfig.getAppId(), InitialVisibility.FORCED);
        this._appConfigService.setInitialAppVisibilityConfigsForRoleAndTenant(tenantManager, null, (ImmutableMap<AppId, InitialVisibility>)ImmutableMap.copyOf(appVisibilitiesForTenantManager));
        LOG.info("Admin app for old customer activated.");
    }
}

